% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseaNb.R
\name{gseaNb}
\alias{gseaNb}
\title{gseaNb}
\arguments{
\item{object}{GSEA enrich results.}

\item{subPlot}{which plot to show, 1/2/3, default is 3.}

\item{lineSize}{curve line size. default is 0.8.}

\item{geneSetID}{which pathway name to plot.}

\item{rmSegment}{whether to remove segment on the curve plot, default is FALSE.}

\item{termWidth}{the width or the term name, defalut is 40.}

\item{segCol}{segment color on the curves, defalut is "red".}

\item{addGene}{whether add gene name on the curve, defalut is FALSE.}

\item{geneCol}{gene name label color, defalut is NULL.}

\item{arrowAngle}{arrow angle, defalut is 20.}

\item{arrowLength}{arrow line length, defalut is 0.2.}

\item{arrowEnd}{arrow end, defalut is "last".}

\item{arrowType}{arrow type, defalut is "closed".}

\item{curveCol}{curve color, defalut is c("#76BA99", "#EB4747", "#996699").}

\item{htCol}{heatmap color, defalut is c("#08519C", "#A50F15").}

\item{rankCol}{gene rank fill color, defalut is c("#08519C", "white", "#A50F15").}

\item{rankSeq}{gene rank plot X axis breaks, defalt is 5000.}

\item{htHeight}{the relative height when "subplot = 2" to the vertical line plot, defalut is 0.3.}

\item{force}{the gene label force, refer to geom_text_repel function, defalut is 20.}

\item{max.overlaps}{refer to geom_text_repel function, defalut is 50.}

\item{geneSize}{gene label text size, defalut is 4.}

\item{newGsea}{whether show new style of plot, defalut is FALSE.}

\item{addPoint}{new style plot with point layer, defalut is TRUE.}

\item{newCurveCol}{new style plot curve color, defalut is c("#336699", "white", "#993399").}

\item{newHtCol}{new style plot heatmap color, defalut is c("#336699", "white", "#993399").}

\item{rmHt}{whether remove new style plot heatmap, defalut is FALSE.}

\item{addPval}{whether add pvalue and NES, defalut is FALSE.}

\item{pvalX}{set pvalue label x position, defalut is 0.9.}

\item{pvalY}{set pvalue label y position, defalut is 0.9.}

\item{pvalSize}{set pvalue label text size, defalut is 4.}

\item{pCol}{pvalue label color, defalut is "grey30".}

\item{pHjust}{pvalue label hjust, defalut is 1.}

\item{rmPrefix}{whether remove GO term prefix like "GOBP/KEGG/CC/MF_*", defalut is TRUE.}

\item{nesDigit}{the NES score digits retained, defalut is 2.}

\item{pDigit}{the pvalue and pajust value digits retained, defalut is 2.}

\item{markTopgene}{whether add top n genes on plot, defalut is FALSE.}

\item{topGeneN}{the number of genes to be marked on plot, defalut is 5.}

\item{kegg}{whether input is gseKEGG object, defalut is FALSE.}

\item{legend.position}{the legend position, defalut is "right".}

\item{whether}{add target gene expression heatmap, defalut is FALSE.}

\item{exp}{the expression matrix,tpm/fpkm/rpkm format, defalut is NULL.}

\item{scale.exp}{whether scale the expression matrix, defalut is TRUE.}

\item{sample.order}{the expression matrix sample orders, defalut is NULL.}

\item{exp.col}{the expression colors, defalut is c('blue','white','red').}

\item{ht.legend}{whether show the heatmap legend, defalut is TRUE.}

\item{ght.relHight}{the relative height to the main plot, defalut is 0.4.}

\item{ght.geneText.size}{the gene lable text size, defalut is 6.}

\item{ght.facet}{whether facet expression heatmap, defalut is FALSE.}

\item{ght.facet.scale}{the facet plot scale argumrnt, defalut is "free".}

\item{termID.order}{the facet term ID orders, defalut is NULL.}

\item{rank.gene}{add your gene label on rank plot, defalut is NULL.}

\item{rank.gene.nudgey}{the gene label nudge y on rank plot, defalut is 2.}
}
\value{
ggplot2 object
}
\description{
gseaNb
}
\examples{
# load data
test_data <- system.file("extdata", "gseaRes.RDS", package = "GseaVis")
gseaRes <- readRDS(test_data)

# all plot
gseaNb(object = gseaRes,
      geneSetID = 'GOBP_NUCLEOSIDE_DIPHOSPHATE_METABOLIC_PROCESS',
      subPlot = 2)
}
\author{
Jun Zhang
}
