% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{weightToLaplacian}
\alias{weightToLaplacian}
\title{Helper function to convert Weight Matrix to Laplacian Matrix}
\usage{
weightToLaplacian(W)
}
\arguments{
\item{W}{The weight matrix for n nodes which should be \code{n}x\code{n} matrix.}
}
\value{
L \code{n}x\code{n} Laplacian matrix.
}
\description{
Helper function to convert Weight Matrix to Laplacian Matrix
}
\examples{
set.seed(20231201)
p <- 5
W <- matrix(0, nrow = p, ncol = p)
W[lower.tri(W)] <- runif(p*(p-1)/2, 0, 1)
W[upper.tri(W)] <- t(W)[upper.tri(W)]
diag(W) <- 1
(L <- weightToLaplacian(W))
}
