% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDStIM.R
\name{HDStIM}
\alias{HDStIM}
\title{HDStIM: High Dimensional Stimulation Immune Mapping}
\usage{
HDStIM(
  dat,
  state_markers,
  cellpop_col,
  stim_lab,
  unstim_lab,
  seed_val = NULL,
  umap = FALSE,
  umap_cells = NULL,
  verbose = FALSE
)
}
\arguments{
\item{dat}{A tibble with the single cell data. Cells on rows
and variables/markers on columns.}

\item{state_markers}{A character vector with the labels of state
markers from the stimulation panel.}

\item{cellpop_col}{Column in the tibble with the cell population IDs.}

\item{stim_lab}{A character vector of stim label(s).}

\item{unstim_lab}{A character of unstim label(s).}

\item{seed_val}{Seed value (integer) for \code{\link{kmeans}} clustering.
Default is NULL for no seed value.}

\item{umap}{Boolean (T/F) to carry out UMAP on the selected cells.
Default is FALSE to skip UMAP calculation.}

\item{umap_cells}{An integer; for calculating UMAPs take a minimum of \code{umap_cells} per
cluster or the total number of cells if the cluster size
is smaller than \code{umap_cells}. Default is NULL.}

\item{verbose}{Logical. To make function more verbose. Default is FALSE.}
}
\value{
A list with tibbles for expression data for the selected cells,
        data to plot stacked bar plots, data to plot UMAP plots, and
        parameters passed to the function.
}
\description{
Function to select cells from the stimulated samples that have likely responded to the stimulant.
}
\examples{
mapped_data <- HDStIM(chi11$expr_data, chi11$state_markers,
                  chi11$cluster_col, chi11$stim_label,
                  chi11$unstim_label, seed_val = 123, umap = FALSE, umap_cells = NULL,
                  verbose = FALSE)
}
