% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_ranking_boruta.R
\name{marker_ranking_boruta}
\alias{marker_ranking_boruta}
\title{Marker Ranking by Boruta}
\usage{
marker_ranking_boruta(
  mapped_data,
  path = NULL,
  n_cells = NULL,
  max_runs = 100,
  seed_val = 123,
  verbose = 0
)
}
\arguments{
\item{mapped_data}{Returned list from the \code{\link{HDStIM}} function.}

\item{path}{Path to the folder to save figures generated by this function.}

\item{n_cells}{Number of cells to down sample the data. Default is NULL to include all the cells.}

\item{max_runs}{Maximum number of runs for the random forest algorithm. Default is 100.}

\item{seed_val}{Seed value for Boruta. Default is 123.}

\item{verbose}{0, 1, or 2. Default is 0.}
}
\value{
A list with a tibble containing attribute statistics calculated by Boruta and ggplot objects. If the path is not NULL, plots are also rendered and saved in the specified folder in PNG format.
}
\description{
Function to run Boruta on the stimulation - cell population combinations that passed the Fisher's exact test to rank the markers according to their contribution to the response.
}
\examples{
\donttest{
mapped_data <- HDStIM(chi11$expr_data, chi11$state_markers,
                      chi11$cluster_col, chi11$stim_label,
                      chi11$unstim_label, seed_val = 123, umap = FALSE, umap_cells = NULL,
                      verbose = FALSE)

attribute_stats <- marker_ranking_boruta(mapped_data, path = NULL, n_cells = NULL,
                                        max_runs = 1000, seed_val = 123,
                                        verbose = 0)
}
}
