% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_refined_anchored_lasso.R
\name{mean_comparison_anchor}
\alias{mean_comparison_anchor}
\title{High-dimensional two-sample mean comparison with anchored projection}
\usage{
mean_comparison_anchor(
  control,
  treatment,
  pca_method = c("dense_pca", "sparse_pca"),
  classifier_method = c("lasso", "group_lasso"),
  lambda_type = "lambda.1se",
  n_folds = 10,
  group = NULL,
  standardize_feature = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{control}{A matrix or data frame for the control group. Rows are samples; columns are features.}

\item{treatment}{A matrix or data frame for the treatment group. Rows are samples; columns are features.}

\item{pca_method}{Character. Method for estimating the projection direction. Options are \code{"dense_pca"} or \code{"sparse_pca"}. Default is \code{"sparse_pca"}.}

\item{classifier_method}{Character. Classifier to guide the projection. Options are \code{"lasso"} or \code{"group_lasso"}. Default is \code{"lasso"}.}

\item{lambda_type}{Character. Regularization parameter choice in Lasso. Options are \code{"lambda.min"} or \code{"lambda.1se"}. Default is \code{"lambda.1se"}.}

\item{n_folds}{Integer. Number of cross-validation folds. Default is 10.}

\item{group}{Optional. A grouping vector (required for \code{group_lasso}), same length as the number of columns in \code{control}.}

\item{standardize_feature}{Logical. Whether to standardize features using pooled mean and standard deviation. Default is TRUE.}

\item{verbose}{Logical. Whether to print messages during execution. Default is TRUE.}
}
\value{
A list with:
\describe{
\item{p_value}{Two-sided p-value for the overall test.}
\item{test_statistic}{Standardized test statistic.}
\item{fold_data}{Per-fold results, including projections and scores.}
}
}
\description{
Performs a cross-validated, projection-based mean comparison between two high-dimensional groups using sparse or dense PCA and (group) Lasso classifiers.
}
\details{
This function applies a projection-based method for high-dimensional mean testing. The projection direction is computed by anchoring the leading principal component with a regularized classifier (Lasso or group Lasso), and test statistics are aggregated across folds.
}
\examples{
\dontrun{
X <- matrix(rnorm(200 * 100), nrow = 100)
Y <- matrix(rnorm(200 * 100), nrow = 100)
result <- mean_comparison_anchor(X, Y, pca_method = "dense_pca", classifier_method = "lasso")
}

}
\seealso{
\code{\link{process_fold_mean_diff}}, \code{\link{combine_folds_mean_diff}}, \code{\link{estimate_leading_pc}}, \code{\link{fit_lasso}}
}
