% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_strickler1923.R
\name{n_strickler1923}
\alias{n_strickler1923}
\title{Compute grain roughness following Strickler (1923)}
\usage{
n_strickler1923(grain, restrict = TRUE)
}
\arguments{
\item{grain}{grain size (d50) in millimeters}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_strickler1923} calculate Manning's n using the Strickler (1923) method
for estimating grain roughness
}
\examples{
# Result: Manning's n of 0.032
n_strickler1923(100)

# Result: Manning's n of 0.025
n_strickler1923(20)

# Result: Manning's n of 0.021
n_strickler1923(8)

# Result: Grain size (mm) must be positive
n_strickler1923(-8)

}
\references{
Strickler, A. 1923. Contributions to the Question of a Velocity formula and Roughness
Data for Streams, Channels Closed Pipelines, translated by T. Roesgan and W.R.
Brownlie. Translation T-10, W.M. Keck Lab of Hydraulics and Water Resources,
California Institute of Technology, Pasadena, CA.
}
