% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hadamard_matrix_method.R
\name{Hadamard_matrix_method}
\alias{Hadamard_matrix_method}
\title{Hadamard_Matrix_method}
\usage{
Hadamard_matrix_method(order, type = -1, method = "", file = "", filetype = "")
}
\arguments{
\item{order}{integer}

\item{type}{-1 or 0}

\item{method}{method=c("Kronecker", "PaleyI","PaleyII","Ehlich","Williamson","Baumert","Goethals-Seidel_Base",
"Goethals-Seidel_Turyn","Miyamoto","Cooper-Wallis","Kronecker_Product_Method","PaleyIPrimepower","PaleyIIPrimePower")}

\item{file}{Name of the file}

\item{filetype}{xlsx or csv}
}
\value{
Hadamard Matrix of given Order
}
\description{
Hadamard_Matrix_method it is also generic function but it provides some additional options.
}
\details{
If the method is not specified or incorrectly specified,
Hadamard matrix will be constructed using Had_method function.
If the method is specified, Hadamard matrix will be constructed using that method.

By default, the elements will be +1 or -1. Incase, -1 should be replaced by 0,
 use type=0.

TO save the generated matrix into a text file (csv) or MS-Excel,
filename may be specified (with extension). In case Excel file required,
use filetype = xlsx, otherwise csv file will be generated.

If just give the input as number it returns Hadamard matrix in console.
}
\examples{
Hadamard_matrix_method(4)
#      [,1] [,2] [,3] [,4]
#[1,]    1    1    1    1
#[2,]    1   -1    1   -1
#[3,]    1    1   -1   -1
#[4,]    1   -1   -1    1
Hadamard_matrix_method(8,method = "PaleyI")
#       [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8]
# [1,]    1    1    1    1    1    1    1    1
# [2,]   -1    1   -1   -1    1   -1    1    1
# [3,]   -1    1    1   -1   -1    1   -1    1
# [4,]   -1    1    1    1   -1   -1    1   -1
# [5,]   -1   -1    1    1    1   -1   -1    1
# [6,]   -1    1   -1    1    1    1   -1   -1
# [7,]   -1   -1    1   -1    1    1    1   -1
# [8,]   -1   -1   -1    1   -1    1    1    1
\donttest{
Hadamard_matrix_method(12,method = "Williamson",
 file =  file.path(tempdir(), "Hadamard12.csv"))
#output saved in file
}
\donttest{
Hadamard_matrix_method(36,method = "Baumert",
file = file.path(tempdir(),"Hadamard36.xlsx"))
#output saved in file
}
\donttest{
Hadamard_matrix_method(20,method = "Miyamoto",
file = file.path(tempdir(),"Hadamard20.csv"),filetype = "csv")
#output saved in file
}
\donttest{
Hadamard_matrix_method(8,method =
"Kronecker",file = file.path(tempdir(),"Hadamard8.xlsx"), filetype = "xlsx")
#output saved in file
}
}
