% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dataformat_wide_to_long}
\alias{dataformat_wide_to_long}
\title{Convert data from wide format to long format}
\usage{
dataformat_wide_to_long(data)
}
\arguments{
\item{data}{The data stored in wide format. The first column is the index for subject (named as sub).
The second column is index for treatment (named as trt). The remaining columns are named time1, time2, etc. See the example.}
}
\value{
The data in long format.
}
\description{
The function dataformat_wide_to_long() takes data in wide format (see the example) and convert to long format so that it will be ready for function Heter.test().
}
\examples{
# Example of data in wide format
# sub trt      time1          time2         time3           time4         time5
 # 1   1  2.4644642  1.7233498 -1.1374695 -0.5242729 -2.379145
 # 2   1  2.5746848  1.0181738 -0.8325308 -2.4873067 -3.463602
 # 3   1  2.5813995 -0.7528324 -3.1457645 -3.3135573 -4.364621
 # 4   1  0.8232141  0.2394987 -2.2073150 -3.3583005 -6.073399
 # 5   1  0.8274860  0.8323298 -2.1028060 -2.6015848 -3.291307
 # 1   2 -2.2217084  0.6779049  3.6310542  3.2052691  4.310316
 # 2   2 -3.3954705 -0.7827040  3.1364749  3.7184895  5.118996
 #
 # Data stored in long format
 # x_{ijk}, k=1, ..., n_i are the kth observation from the ith subject at time j.
 # 1 1 1 x111
 # 1 1 2 x112
 # 1 2 1 x121
 # 1 2 2 x122
 # 1 2 3 x123

 #  The following example generate a data set that contains data from
 # 3 treatments, with 3 subjects in treatment 1, 3 subjects in treatment 2,
 # and 4 subjects in treatment 3. Each subject contains m=50
 # repeated observations from Poisson distribution. For the 1st treatment,
 # the mean vector of the repeated observations from the same subject is
 # equal to mu1 plus a random effect vector generated by NorRanGen( ).
 # The m is the number of repeated measurements per subject.
 f1<-function(m, mu1, raneff) {
     currentmu=mu1+raneff;
     currentmu[abs(currentmu)<1e-2]=1e-2;
     rpois(m, abs(currentmu))}
 f2<-function(m, mu2, raneff) {
     currentmu=mu2+raneff;
     currentmu[abs(currentmu)<1e-2]=1e-2;
     rpois(m, abs(currentmu))}
 f3<- function(m, mu3, raneff){
     currentmu=mu3+raneff;
     currentmu[abs(currentmu)<1e-2]=1e-2;
     rpois(m, abs(currentmu))}

 # The a is the number of treatments. The mn stores the number of subjects in treatments.
 a=3;  mn=c(3, 3, 4); mu1=3; mu2=3; mu3=3; m=50
 raneff=NorRanGen(m) # generate random effects with AR(1) structure.

 # Generate data and store in wide format.
datawide=numeric()
now=0
for (i in 1:a){
   fi=function(x1, x2) f1(m,x1, x2)*(i==1)+f2(m,x1, x2)*(i==2)+f3(m, x1, x2)*(i==3)
   mu=mu1*(i==1)+mu2*(i==2)+mu3*(i==3)
   for (k in 1:mn[i]){
          now=now+1
          datawide<-rbind(datawide, c(k, i, fi(mu, raneff) )   	)
          colnames(datawide)=c("sub", "trt", paste("time", seq(m), sep=""))
          #this is a typical way to store data in practice
    }
 } #end of j

 dat=dataformat_wide_to_long(datawide)
}
