% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_KGE_DOY.R
\name{benchmark_KGE_DOY}
\alias{benchmark_KGE_DOY}
\title{Calculate benchmark Kling--Gupta efficiency (KGE) values from day-of-year (DOY) observations}
\usage{
benchmark_KGE_DOY(obs_preproc)
}
\arguments{
\item{obs_preproc}{'data.frame' of daily observational data, preprocessed as output from \cr
\code{\link{preproc_precondition_data}} or \code{\link{preproc_main}} \code{"daily"}.}
}
\value{
A data.frame with columns \code{"KGE_DOY_mean"} and \code{"KGE_DOY_median"}.
}
\description{
Calculate benchmark Kling--Gupta efficiency (KGE) values from daily observed
time-series data
}
\details{
This function calculates a "benchmark" KGE value (see Knoben and others, 2020) from a daily
observed data time-series. First, the interannual mean and median is calculated for each day of
the calendar year. Next, the interannual mean and median values are joined to each corresponding
day in the observation time series. Finally, a KGE value (\code{\link{GOF_kling_gupta_efficiency}}) is
calculated comparing the mean or median value repeated time series to the daily observational
time series. These benchmark KGE values can be used as comparisons for modeled (simulated)
calibration results.
}
\examples{
benchmark_KGE_DOY(obs_preproc = example_preproc)

}
\references{
Knoben, W.J.M, Freer, J.E., Peel, M.C., Fowler, K.J.A, Woods, R.A., 2020. A Brief Analysis of
Conceptual Model Structure Uncertainty Using 36 Models and 559 Catchments: Water Resources
Research, v. 56.\cr
[Also available at https://doi.org/10.1029/2019WR025975.]
}
\keyword{benchmark}
\keyword{goodness-of-fit}
