% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{SimpleReadVCF}
\alias{SimpleReadVCF}
\title{Read a VCF file into a data frame with minimal processing.}
\usage{
SimpleReadVCF(file)
}
\arguments{
\item{file}{The name/path of the VCF file, or a complete URL.}
}
\value{
A data frame storing mutation records of a VCF file.
}
\description{
Read a VCF file into a data frame with minimal processing.
}
\details{
Header lines beginning "##" are removed, and column
  "#CHROM" is renamed to "CHROM". Other column names are
  unchanged. Columns "#CHROM", "POS", "REF", and "ALT" must
  be in the input.
}
\examples{
file <- c(system.file("extdata/Strelka-SBS-vcf",
                      "Strelka.SBS.GRCh37.s1.vcf",
                      package = "ICAMS"))
df <- SimpleReadVCF(file)
}
