% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcNpmleRSP.R
\name{CalcNpmleRSP}
\alias{CalcNpmleRSP}
\title{Calculating the probabilities of positive binary exposure status at a given time point using a nonparametric risk-set calibration models}
\usage{
CalcNpmleRSP(w, w.res, point, obs.tm)
}
\arguments{
\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. Each measurement corresponds to the time points in \code{w}}

\item{point}{The time point at which the probabilities are estimated}

\item{obs.tm}{Vector of observed main event time or censoring time}
}
\value{
A vector of estimated probabilities of positive exposure status at time \code{point}.
}
\description{
For a given time point, calculate the probability of positive exposure value  for multiple observations (participants). 
The function first fits the nonparametric risk-set calibration models at each main event time point and then calculates the probabilities
of positive binary exposure status.
}
\details{
This function calculates the NPMLE at each main event time point and then provides the estimated probabilities for positive 
exposure status at time \code{point}.
}
\examples{
# Simulate data set
sim.data <- ICcalib:::SimCoxIntervalCensSingle(n.sample = 200, lambda = 0.1, 
                                               alpha = 0.25, beta0 = log(0.5), 
                                               mu = 0.2, n.points = 2, 
                                               weib.shape = 1, weib.scale = 2)
# Calculate the conditional probabilities of binary covariate=1 at time one
# Unlike CalcNpmle, CalcNpmleRSP includes the calibration model fitting
probs <- CalcNpmleRSP(w = sim.data$w, w.res = sim.data$w.res, point = 1, 
                      obs.tm = sim.data$obs.tm)
summary(probs)
}
\seealso{
\code{\link[icenReg]{ic_np}}
}
