% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{s_e_points}
\alias{s_e_points}
\title{Derives a subset of integers from a given set}
\usage{
s_e_points(r, l, s, e)
}
\arguments{
\item{r}{A positive integer vector containing the set, from which the end-points
of the expanding intervals are to be chosen.}

\item{l}{A positive integer vector containing the set, from which the start-points
of the expanding intervals are to be chosen.}

\item{s}{A positive integer indicating the starting position, in the sense that we will
choose the elements from \code{r} and \code{l} that are greater than \code{s}.}

\item{e}{A positive integer indicating the finishing position, in the sense that we will
choose the elements from \code{r} and \code{l} that are less than \code{e}.}
}
\value{
\code{e_points}  A vector containing the points that will be used as end-points,
  in order to create the left-expanding intervals. It consists of the input \code{e} and
  all the elements in the input vector \code{r} that are in \code{(s,e)}.

  \code{s_points}  A vector containing the points that will be used as start-points,
  in order to create the left-expanding intervals. It consists of the input \code{s} and
  all the elements in the input vector \code{l} that are in \code{(s,e)}
}
\description{
This function finds two subsets of integers in a given interval \code{[s,e]}.
The routine is typically not called directly by the user; its result
is used in order to construct the expanding intervals, where the Isolate-Detect method
is going to be applied. For more details on how the Isolate-Detect methodology works, see
References.
}
\examples{
s_e_points(r = seq(10,1000,10), l = seq(991,1,-10), s=435, e = 786)
s_e_points(r = seq(3,100,3), l = seq(98,1,-3), s=43, e = 86)
}
\references{
Anastasiou, A. and Fryzlewicz, P. (2018). Detecting multiple generalized change-points
by isolating single ones.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
