% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcF.R
\name{calcF}
\alias{calcF}
\title{Calculate F-values for individual identity traits}
\usage{
calcF(df)
}
\arguments{
\item{df}{A data frame with the first column indicating individual identity.}
}
\value{
A data frame with 11 rows and 3 columns (trait, f-value, and p-value).
}
\description{
This function calculates ANOVA F-values (type I sum of squares) for all
identity traits in dataset along with its significance. Each trait is used as
dependent and identity code as independent variable. \cr\cr \strong{Reference:} e.g., Miller, D. B. (1978). Species-typical and individually distinctive acoustic features of crow calls of red jungle fowl. Zeitschrift Fur Tierpsychologie-Journal of Comparative Ethology, 47, 182–193.
}
\examples{
calcF(ANmodulation)

}
\seealso{
Other individual identity metrics: \code{\link{calcDS}},
  \code{\link{calcHM}}, \code{\link{calcHSngroups}},
  \code{\link{calcHSnpergroup}}, \code{\link{calcHSntot}},
  \code{\link{calcHSvarcomp}}, \code{\link{calcHS}},
  \code{\link{calcMI}}, \code{\link{calcPICbetweenmeans}},
  \code{\link{calcPICbetweentot}}, \code{\link{calcPIC}}
}
\concept{individual identity metrics}
