% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHSvarcomp.R
\name{calcHSvarcomp}
\alias{calcHSvarcomp}
\title{Calculate Beecher's information statistic (HS, variant = HSvarcomp)}
\usage{
calcHSvarcomp(df, sumHS = T)
}
\arguments{
\item{df}{A data frame with the first column indicating individual identity.}

\item{sumHS}{\code{sumHS = TRUE} (default) will sum partial HS values of
each trait variable; \code{sumHS = FALSE} provides partial HS values separately for each
individuality trait in a dataset.}
}
\value{
For \code{sumHS = TRUE}: Numeric vector of two elements indicating indicating: 1) HS summed
  over variables that significantly differ between individuals (in one-way
  Anova with individual as independent and a specific signal trait as
  dependent variable; or 2) HS summed over all variables in dataset.

  For \code{sumHS = FALSE}: Data frame with thre columns and number of rows equal to
  number of variables in dataset. First column includes names of traits
  considered for individuality. Second column includes significance test for
  each trait (from one-way ANOVA with individual identity as independent
  factor and trait as dependent variable). Third column includes values of HS
  for each variable trait.
}
\description{
This function calculates Beecher's information statistic (HS) for all
variables within the dataset. \cr\cr \strong{Reference:}
from Beecher, M. D. (1989). Signaling Systems for Individual Recognition - an
Information-Theory Approach. Animal Behaviour, 38, 248-261.
doi:10.1016/S0003-3472(89)80087-9. \cr\cr \code{calcHS} (equivalent to \code{calcHSnpergroup}) is the
correct variant of the function calculating Beechers information statistic. The other
variants use total sample size (\code{calcHSntot}) or number of individuals in dataset (\code{calcHSngroups}) instead of
number of samples per individual to calculate HS. \code{calcHSvarcomp} calculates
HS from variance components of mixed models. HS values calculated by
\code{calcHSvarcomp} were found to be twice as large compared to HS calculated by standard
approach. \cr\cr Please note, \code{sumHS = TRUE} should be used in datasets where
individuality traits are uncorrelated. If traits are correlated, Principal
component analysis (PCA) should be applied and HS should be calculated on
uncorrelated principal componenets instead of original trait variables.
}
\examples{
calcHSvarcomp(ANmodulation)
temp <- calcPCA(ANmodulation)
calcHSvarcomp(temp)

}
\seealso{
\code{\link{calcPIC}}, \code{\link{calcHS}}

Other individual identity metrics: \code{\link{calcDS}},
  \code{\link{calcF}}, \code{\link{calcHM}},
  \code{\link{calcHSngroups}},
  \code{\link{calcHSnpergroup}}, \code{\link{calcHSntot}},
  \code{\link{calcHS}}, \code{\link{calcMI}},
  \code{\link{calcPICbetweenmeans}},
  \code{\link{calcPICbetweentot}}, \code{\link{calcPIC}}
}
\concept{individual identity metrics}
