% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mint.R
\name{h.fn.exp}
\alias{h.fn.exp}
\title{Mean Intensity of the Self-Exciting Point Process With an
  Exponential Excitation Function}
\description{
\code{h.fn.exp} calculates the mean intensity function \eqn{h(t)} which
solves the integral equation \deqn{h(t)=\nu(t)+\int_0^t g(t-s)h(s)ds,
  t\geq 0}, where the excitation function is exponential: \eqn{g(t)=
  \gamma_1 e^{-\gamma_2t}}.
}
\usage{
h.fn.exp(x, nu, g.p = c(4, 8))
}
\arguments{
\item{x}{numerical scalar, at which the mean intensity \eqn{h} is to be evaluated}

\item{nu}{a function, which gives the baseline event rate}

\item{g.p}{a numeric vector of two elements giving the two parameters \eqn{\gamma_1,\gamma_2} of the exponential excitation function}
}
\value{
a numric scalar which gives the value of the function \eqn{h} at \code{x}.
}
\examples{
nu <- function(x)200+100*cos(pi*x);
x <- 1:500/100;
y <- sapply(x,h.fn.exp,nu=nu,g.p=c(2,1));
h <- splinefun(x,y);
g <- function(x)2*exp(-x)
round(nu(x)+sapply(x,function(x)integrate(function(u)g(x-u)*h(u),0,x)$value) - y,5)
}
\seealso{
\code{\link{h.fn}}
}

