% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigraph_from_mat.R
\encoding{UTF-8}
\name{trigraph_from_mat}
\alias{trigraph_from_mat}
\title{Transforming two matrices into an igraph object.}
\usage{
trigraph_from_mat(mat1, mat2, weighted = FALSE)
}
\arguments{
\item{mat1}{A numeric matrix representing the first subnetwork. Rows should be the shared set of species.}

\item{mat2}{A numeric matrix representing the second subnetwork. Rows should be the shared set of species.}

\item{weighted}{Logical. Default to FALSE. If TRUE, a weighted measure is provided.}
}
\value{
Return a network of type "igraph".
}
\description{
Transform two matrices into an igraph object.
}
\details{
In this package, a tripartite network contains three groups of nodes (a-nodes,b-nodes,c-nodes)  and two subnetworks (P includes the links between a-nodes and b-nodes, Q includes the links between b-nodes and c-nodes). Connector nodes belong to b-nodes.
Please make sure the rows of \code{mat1} and \code{mat2} both represent the groups of connector species,i.e, the b-group species. If both matrices have row names, then the function matches row
names to define connector nodes. Otherwise, row numbers are assigned to row names and matched, which might produce an incorrected network. Within the two matrices (P and Q), columns represents a-group nodes and c-group nodes respectively.
Elements in matrices are non-zero values if two nodes are linked with or without weights, and 0 otherwise.
}
\examples{

set.seed(12)
MAT <- build_toy_net(11,22,21,0.2,output_matrices=TRUE)
M <- trigraph_from_mat((MAT[[3]]),MAT[[4]])
M
}
