% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.qcs.R
\name{grubbs.test}
\alias{grubbs.test}
\alias{grubbs.test.default}
\alias{grubbs.test.lab.qcdata}
\title{Function to compute the Grubbs test statistic}
\usage{
grubbs.test(x, ...)

\method{grubbs.test}{default}(
  x,
  var.index = 1,
  replicate.index = 2,
  material.index = 3,
  laboratory.index = 4,
  data.name = NULL,
  alpha = 0.05,
  ...
)

\method{grubbs.test}{lab.qcdata}(x, alpha = 0.05, ...)
}
\arguments{
\item{x}{An object of class \code{lab.qcdata} (Univariate Quality Control Data).}

\item{...}{Other arguments passed to or from methods.}

\item{var.index}{A scalar with the column number corresponding to the observed variable (the critical to quality variable).
Alternativelly can be a string with the name of the quality variable.}

\item{replicate.index}{A scalar with the column number corresponding to the index each replicate.}

\item{material.index}{A scalar corresponding to the replicated number.}

\item{laboratory.index}{A scalar that defines the index number of each laboratory.}

\item{data.name}{A string specifying the name of the variable which appears on the plots.
If name is not provided, it is taken from the object given as data.}

\item{alpha}{The significance level (0.05 for default)}
}
\description{
Function to estimate the Grubbs test statistic.
}
\examples{

library(ILS)
data(Glucose)
Glucose.qcdata<- lab.qcdata(Glucose)
str(Glucose.qcdata)
grubbs.test(Glucose.qcdata)
}
\references{
Wilrich Peter-T. (2013), Critical values of Mandel's h and k,
the Grubbs and the Cochran test statistic. Asta-Advances in Statistical Analysis, 97(1):1-10.

ASTM E 691 (1999), Standard practice for conducting an interlaboratory study
to determine the precision of a test method. American Society for Testing and Materials. West Conshohocken, PA, USA.
}
