% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidator.R
\name{consolidator}
\alias{consolidator}
\title{Consolidates QC files}
\usage{
consolidator(filename, x)
}
\arguments{
\item{filename}{ECA&D file name, expressed as VV_SOUIDXXXXXX.txt, where "VV" is the two-letters variable code, "SOUID" is literal,
XXXXXX is the ECA&D SOUID code and ".txt" is literal}

\item{x}{QCed series, formatted as date, value, QC flag}
}
\value{
It does not return any value. Each time when called, it will create three files:
Summary file,  placed at ./QCSumamry/SummaryVV_SOUIDXXXXXX.txt;
QC consolidated file, placed at ./QCConsolidated/VV_SOUIDXXXXXX.txt;
Verbose QC file, placed at ./QC/qc_VV_SOUIDXXXXXX.txt.
}
\description{
This function is not intended to be called as a stand-alone function. It is automatically called each time a file ends its QC.
It will write the quality control files. One file will be placed in a subfolder of the homefolder named QCConslidated. It will use the exact ECA&D
format (date, value, QC flag). The QC flags include:

0: Passed QC;
1: ERROR;
2: ALMOST CERTAIN, ERROR;
3: OUTLIER, SUSPECT;
4: COLLECTIVELY SUSPECT;
9: Missing value.

A second file is placed in the subfolder QC and includes all date, value and a column for each QC test ran over this file. Values passing/not passing QC
are labelled with 0/1. A third file summarizes the number of values falling on each category (0,1,2,3,4,9) and the number of values failing each test
}
