% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{admin2020}
\alias{admin2020}
\title{Administration 2020 Data}
\format{
A data frame of  63,843 rows representing full-time instructional staff on the payroll of the institution and 34 variables

\describe{
\item{INSTITUTION_ID}{Unique identification number of the institution}
\item{STAFF_CAT}{Staff Category (Refer to \code{staff_cat} dataset for more details.)}
\item{FACSTAT}{Faculty and tenure status (0 = All full-time instructional staff; 10 = With faculty status, total; 20	= With faculty status, tenured; 30 = With faculty status, on tenure track; 40	= With faculty status not on tenure track/No tenure system, total; 41	= With faculty status not on tenure track/No tenure system, multi-year and indefinite contract; 44 = With faculty status not on tenure track/No tenure system, multi-year contract; 45 = With faculty status not on tenure track/No tenure system, indefinite contract; 42 = With faculty status not on tenure track/No tenure system, annual contract; 43 = With faculty status not on tenure track/No tenure system, less-than-annual contract; 50 = Without faculty status)}
\item{ARANK}{Academic rank: a factor with 7 levels: \verb{All ranks}, \code{Professors}, \verb{Associate professors}, \verb{Assistant professors}, \code{Instructors}, \code{Lecturers} and \verb{No academic rank}}{Academic rank}
\item{TOTAL}{Grand total individuals}
\item{TOTAL_M}{Grand total men}
\item{TOTAL_W}{Grand total women}
\item{NATIVE_TOTAL}{American Indian or Alaska Native total}
\item{NATIVE_MEN}{American Indian or Alaska Native men}
\item{NATIVE_WOMEN}{American Indian or Alaska Native women}
\item{ASIAN_TOTAL}{Asian total}
\item{ASIAN_M}{Asian men}
\item{ASIAN_W}{Asian men}
\item{BLACK_TOTAL}{Black or African American total}
\item{BLACK_M}{Black or African American men}
\item{BLACK_W}{Black or African American women}
\item{HISP_TOTAL}{Hispanic or Latino total}
\item{HISP_M}{Hispanic or Latino men}
\item{HISP_W}{Hispanic or Latino women}
\item{NHPI_TOTAL}{Native Hawaiian or Other Pacific Islander total}
\item{NHPI_M}{Native Hawaiian or Other Pacific Islander men}
\item{NHPI_W}{Native Hawaiian or Other Pacific Islander women}
\item{WHITE_TOTAL}{White total}
\item{WHITE_M}{White men}
\item{WHITE_W}{White women}
\item{MULT_TOTAL}{Two or more races total}
\item{MULT_M}{Two or more races men}
\item{MULT_W}{Two or more races women}
\item{UNKNOWN_TOTAL}{Race/ethnicity unknown total}
\item{UNKNOWN_M}{Race/ethnicity unknown men}
\item{UNKNOWN_W}{Race/ethnicity unknown women}
\item{NRA_TOTAL}{Nonresident alien total}
\item{NRA_M}{Nonresident alien men}
\item{NRA_W}{Nonresident alien women}
}
}
\source{
Download from Integrated Postsecondary Education Data System,
\url{https://nces.ed.gov/ipeds/datacenter/data/S2020_IS.zip}.
}
\usage{
admin2020
}
\description{
This file contains the number of full-time instructional staff on the payroll of the institution as of November 1,  by faculty and tenure status, academic rank, race/ethnicity and gender. This file has multiple records per institution.  Each record is uniquely defined by the variables IPEDS ID (INSTIUTION_ID). These data are applicable to degree-granting institutions with 15 or more full-time employees and related administrative offices.
}
\details{
Provisional release data have undergone all NCES data quality control procedures. Data are imputed for nonresponding institutions.
}
\keyword{datasets}
