% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{complete2020}
\alias{complete2020}
\title{Completions 2020 Data}
\format{
A data frame of 15937 rows representing institutions and 19 variables

\describe{
\item{INSTITUTION_ID}{Unique identification number of the institution}
\item{AWARD_LVL}{Award Level code (3	= Associate's degree; 5	= Bachelor's degree; 7 = Master's degree; 9	= Doctor's degree; 10	= Postbaccalaureate or Post-master's certificate; 11 = Certificate of less than 12 weeks; 12 = Certificate of at least 12 weeks but less than 1 year; 2	= Certificate of at least 1 but less than 4 years)}
\item{TOTAL}{Grand total individuals}
\item{TOTAL_M}{Grand total men}
\item{TOTAL_W}{Grand total women}
\item{TOTAL_NATIVE}{American Indian or Alaska Native total}
\item{TOTAL_ASIAN}{Asian total}
\item{TOTAL_BLACK}{Black or African American total}
\item{TOTAL_HISP}{Hispanic or Latino total}
\item{TOTAL_NHPI}{Native Hawaiian or Other Pacific Islander total}
\item{TOTAL_WHITE}{White total}
\item{TOTAL_MULT}{Two or more races total}
\item{TOTAL_UNKNOWN}{Race/ethnicity unknown total}
\item{TOTAL_NRA}{Nonresident alien total}
\item{UND18}{Ages, under 18}
\item{AGE18_24}{Ages, 18-24}
\item{AGE25_39}{Ages, 25-39}
\item{AGE40PLUS}{Ages, 40 and above}
\item{AGE_UNKNOWN}{Age unknown}
}
}
\source{
Download from Integrated Postsecondary Education Data System,
\url{https://nces.ed.gov/ipeds/datacenter/data/C2020_C.zip}.
}
\usage{
complete2020
}
\description{
This file contains the number of students receiving a degree or certificate by level of award and by race/ethnicity,  gender and age categories. Data covers awards granted between July 1, 2019 and June 30, 2020. This file contains multiple records per institution. Each record will contain the total number of students receiving awards;  number of  men and women receiving awards: number of students receiving awards for all nine race/ethnicity categories; number of students receiving awards are also available for the following age groups: under 18, 18-24, 25-39, 40 and above.
}
\details{
Provisional release data have undergone all NCES data quality control procedures. Data are imputed for nonresponding institutions.
}
\keyword{datasets}
