% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{offerings2020}
\alias{offerings2020}
\title{Offerings Data}
\format{
A data frame of 6264 rows representing institutions and 114 variables

\describe{
\item{INSTITUTION_ID}{Unique identification number of the institution}
\item{OCCUPATIONAL}{Occupational Program - A program of study consisting of one or more courses, designed to provide the student with sufficient knowledge and skills to perform in a specific occupation.}
\item{ACADEMIC}{Academic Program - Instructional program leading toward an associate's, bachelor's, master's, doctor's, or first-professional degree or resulting in credits that can be applied to one of these degrees. }
\item{CONTIN_PROFESS}{Continuing Professional Education - Programs and courses designed specifically for individuals who have completed a professional degree (such as law, medicine, dentistry, or social work) to obtain additional training in their particular field of study }
\item{RECREATE_AVO}{Avocational Programs - Instructional programs in personal interest and leisure categories whose expressed intent is not to produce postsecondary credits, nor to lead to a formal award or an academic degree, nor result in occupationally specific skills.}
\item{REMEDIAL}{Adult Basic Education - Courses designed primarily for students 16 years of age and older to improve basic skills in reading, writing, and arithmetic. These courses are not intended to be part of a program leading to a high school degree, nor are they part of any academic, occupational, or vocational program at the postsecondary level. }
\item{SECONDARY}{Secondary (high school)}
\item{AFFILIATION}{Institutional control or affiliation (1	= Public, 2	= Private for-profit, 3	= Private not-for-profit (no religious affiliation), 4 = Private not-for-profit (religious affiliation))}
\item{PRIMARY_CON}{Indicates primary control for public institutions (1 = Federal, 2	= State, 3 = Territorial, 4	= School district, 5 = County, 7 = City, 8 = Special district, 9 = Other, -2 = Not applicable)}
\item{SECOND_CON}{Indicates secondary control for public institutions (1 = Federal, 2	= State, 3 = Territorial, 4	= School district, 5 = County, 7 = City, 8 = Special district, 9 = Other, -2 = Not applicable)}
\item{RELIG_AFF}{Indicates religious affiliation (denomination) for private not-for-profit institutions that are religiously affiliated. (See \code{relig_aff} dataset for more information.)}
\item{CERT_1Y}{What award levels are offered by your institution? Postsecondary award, certificate, or diploma of less than 900 clock hours, or 30 semester or trimester credit hours, or 45 quarter credit hours (less than 1 year)}
\item{CERT_12W}{What award levels are offered by your institution? Postsecondary award, certificate, or diploma  of less than 300 clock hours, 9 semester or trimester credit hours, or 13 quarter credit hours  (less than 12 weeks)}
\item{CERT_L1Y}{What award levels are offered by your institution? Postsecondary award, certificate, or diploma of  300-899 clock hours, or 9-29 semester or trimester credit hours, or13-44 quarter credit hours (at least 12 weeks, but less than 1 year)}
\item{CERT_L2Y}{What award levels are offered by your institution? Postsecondary award, certificate, or diploma of at least 900 but less than 1,800 clock hours, or at least 30 but less than 60 semester or trimester credit hours, or at least 45 but less than 90 quarter credit hours (at least 1 year but less than 2 years)}
\item{ASSOCIATES}{What award levels are offered by your institution? Associate's degree }
\item{CERT_L4Y}{What award levels are offered by your institution? Postsecondary award, certificate, or diploma of 1,800 or more clock hours, or 60 or more semester or trimester credit hours, or 90 or more quarter credit hours (at least 2 but less than 4 years)}
\item{BACHELORS}{What award levels are offered by your institution? Bachelor's degree or equivalent }
\item{POST_BACH}{What award levels are offered by your institution? Postbaccalaureate certificate }
\item{MASTERS}{What award levels are offered by your institution? Master's degree }
\item{POST_MASTERS}{What award levels are offered by your institution? Post-master's certificate}
\item{OTHER}{What award levels are offered by your institution? Other; please specify }
\item{DOC_RS}{What award levels are offered by your institution? Doctorate's degree - research/scholarship}
\item{DOC_P}{What award levels are offered by your institution? Doctorate's degree - professional practice}
\item{DOC_O}{What award levels are offered by your institution? Doctorate's degree - other}
\item{CALSYS}{Standard academic term (1	= Semester, 2	= Quarter, 3 = Trimester, 4	= Four-one-four plan, 5	= Other academic year, 6 = Differs by program, 7 = Continuous, -2	= Not applicable)}
\item{FT_UG}{Undergraduate (academic or occupational programs), full-time students}
\item{FT_FTUG}{First-time degree/certificate-seeking undergraduate, full-time students}
\item{FTGDNIDP}{Graduate (not including doctor's professional practice), full-time students}
\item{PT_UG}{Undergraduate (academic or occupational programs), part-time students}
\item{PT_FTUG}{First-time degree/certificate-seeking undergraduate, part-time students}
\item{PTGDNIDP}{Graduate (not including doctor's professional practice), part-time students}
\item{DOC_P_E}{Students in doctor's - professional practice programs}
\item{DOC_PF}{Students in doctor's - professional practice programs}
\item{OPENADMP}{Open Admission - Admission policy whereby the school will accept any student who applies.}
\item{VET_YELLOWR}{Yellow Ribbon Program - A voluntary program through which participating public and private institutions can provide veterans and eligible beneficiaries additional institutional aid to cover the costs of tuition and fees at their institutions. The Yellow Ribbon Program is a supplementary program to the Post 9/11 GI Bill coverage of in-state tuition and fees. The Department of Veterans Affairs matches the institutional aid provided beyond the in-state tuition and fees, but to certain limit each year}
\item{VET_MTC}{Credit for Military Training - Postsecondary credit granted by institutions to military servicemen or veterans for experiences and training gained while in the service.}
\item{VET_SUPP}{Dedicated point of contact for support services for veterans, military service members, and their families }
\item{VET_ORG}{Recognized student veteran organization }
\item{VET_SOC}{Member of Service members Opportunity Colleges }
\item{VET_NA}{None of aforementioned programs available to veterans, military servicemembers, or their families}
\item{DUAL}{Accept Dual Enrollment - Refers to students who enroll in college courses offered by an institution of higher education while enrolled in high school or seeking a recognized equivalent. Student performance is recorded on a college transcript and postsecondary credit is awarded for a passing grade in the course. Includes: All postsecondary courses, independent of course delivery mode, course location, course instructor, whether secondary credit is also offered, and whether the student enrolls through a formal state/local program or enrolls outside a formal state/local program. Excludes: Credit-by-exam models such as Advanced Placement and International Baccalaureate in which the student is not enrolled in a postsecondary institution.}
\item{LIFE_EXP}{Accept Credit for Life Experiences - Credit earned by students for what they have learned through independent study, noncredit adult courses, work experience, portfolio demonstration, previous licensure or certification, or completion of other learning opportunities (military, government, or professional). Credit may also be awarded through a credit by examination program}
\item{AP}{Accept Advanced Placement - Advanced placement courses are college-level courses taught in high school. Students may take an examination at the completion of the course; acceptable scores allow students to earn college credit.}
\item{CRED_NA}{Accept none of the aforementioned credit}
\item{ROTC}{ROTC}
\item{ROTC_ARMY}{ROTC Army}
\item{ROTC_NAVY}{ROTC Navy}
\item{ROTC_AIR}{ROTC Air Force}
\item{STUDY_ABROAD}{Study Abroad - Arrangement by which a student completes part of the college program studying in another country. Can be at a campus abroad or through a cooperative agreement with some other U.S. college or an institution of another country.}
\item{WKEND_EV}{Weekend/evening College - A program that allows students to take a complete course of study and attend classes only on weekends or only in evenings.}
\item{TEACH_CERT}{Teacher certification (below the postsecondary level) }
\item{TEACH_CERT_S}{Teacher certification (below the postsecondary level). Students can complete their  preparation in certain areas of specialization}
\item{TEACH_CERT_O}{Teacher certification (below the postsecondary level). Students must complete their preparation at another institution for certain areas of specialization }
\item{TEACH_CERT_STATE}{Teacher certification (below the postsecondary level). This institution is approved by the state for the initial certification or licensure of teachers }
\item{SLNA}{Institution does not have any of the following special learning opportunities: Accelerated programs, Cooperative (work study), Distance learning, Dual enrollment, ROTC, Study abroad, Weekend college, or Teacher certification (below thepostsecondary level).}
\item{YRSCOLL}{Years of completed college-level work are required for entrance (1 = One, 2	= Two, 3 = Three, 4 = Four, 5 = Five, 6 = Six, 8 = Eight, -1 = Not reported, -2	= Not applicable)}
\item{REME_SERV}{Offers Remedial Services - Instructional activities designed for students deficient in the general competencies necessary for a regular postsecondary curriculum and educational setting.}
\item{ACAREER_SERV}{Offers Counseling Services - Activities designed to assist students in making plans and decisions related to their education, career, or personal development.}
\item{EMPLOY_SERV}{Offers Employment Services for Current Students - Activities intended to assist students in obtaining part-time employment as a means of defraying part of the cost of their education.}
\item{PLACE_SERV}{Offers Placement Services for Program Completers - Assistance for students in evaluating their career alternatives as well as in obtaining full-time employment upon leaving the institution.}
\item{DAYCARE}{Offers Daycare Services - A student service designed to provide appropriate care and protection of infants, preschool, and school-age children so their parents can participate in postsecondary education programs.}
\item{SERVNA}{None of the following selected students services are offered: Remedial services, Academic/career counseling services, Employment services for current students, Placement services for program completers, or On-campus day care for children of students}
\item{LIB_PHYS}{Library offers Physical facilities}
\item{LIB_PRINT}{Library offers an organized collection of printed materials}
\item{LIB_DIGI}{Library offers access to digital/electronic resources}
\item{LIB_STAFF}{Library offers a staff trained to provide and interpret library materials}
\item{LIB_HOURS}{Library offers established library hours}
\item{LIB_COLLECT}{Library offers access to library collections that are shared with other institutions}
\item{LIB_NA}{Library offers none of the above}
\item{TUIT_ALT}{Alternative tuition plans are offered}
\item{TUIT_GUARAN}{Offers tuition guarantee}
\item{TUIT_PREPAID}{Offers prepaid tuition plan}
\item{TUIT_PAY}{Offers tuition payment plan}
\item{TUIT_OALT}{Offers other - (not one of the above alternative plans)}
\item{DIST_EDUC_UGC}{Offers Undergraduate level distant education courses}
\item{DIST_EDUC_UGP}{Offers Undergraduate level distant education programs}
\item{DIST_EDUC_UGN}{Undergraduate level distant education not offered}
\item{DIST_EDUC_GC}{Offers Graduate level distant education courses}
\item{DIST_EDUC_GP}{Offers Graduate level distant education programs}
\item{DIST_EDUC_GN}{Graduate level distant education not offered}
\item{DIST_EDUC_C}{Offers a course in which the instructional content is delivered exclusively via distance education}
\item{DIST_EDUC_P}{Offers Distant education programs offered}
\item{DIST_EDUC_UGCP}{Offers Undergraduate distance education opportunities}
\item{DIST_EDUC_GCP}{Offers Graduate distance education opportunities}
\item{DIST_EDUC_NA}{Does not offer distance education opportunities}
\item{DIST_EDUC_ALL}{Offers a program for which all the required coursework for program completion is able to be completed via distance education courses.}
\item{DISAB}{Percentage of all undergraduates enrolled in Fall 2019 who are formally registered as students with disabilities with the institution's office of disability services (or the equivalent office)(1 = 3 percent or less, 2 = More than 3 percent)}
\item{LIVE_ONCAMP}{First-time degree/certificate-seeking students required to live on campus or in institutionally-controlled housing}
\item{TUITVARY}{Charges different tuition for in-district, in-state, or out-of-state students}
\item{ROOM}{Provides on-campus housing}
\item{ROOMCAP}{Dormitory capacity - The maximum number of students that the institution can provide residential facilities for, whether on or off campus. (off-campus dormitory space that is reserved by the institution).}
\item{BOARD}{Provides board or meal plans to students (1	= Yes, number of meals in the maximum meal plan offered, 2 = Yes, number of meals per week can vary)}
\item{MEALSWK}{Number of meals per week in the maximum meal plan offered}
\item{ROOM_PRICE}{Typical room charges for a student for the full academic year 2018-19 }
\item{BOARD_PRICE}{Typical board charges for a student for the full academic year 2018-19 }
\item{R_B_PRICE}{Typical room and board charges for a student for the full academic year 2018-19. (applicable only if institution CANNOT separate room and board charges.)}
\item{APPLFEEU}{Undergraduate application fee amount}
\item{APPLFEEG}{Graduate application fee amount}
\item{NAA}{Member of National Athletic Association}
\item{NCAA}{Member of National Collegiate Athletic Association (NCAA)}
\item{NAIA}{Member of National Association of Intercollegiate Athletics (NAIA)}
\item{NJCAA}{Member of National Junior College Athletic Association (NJCAA)}
\item{NSCAA}{Member of National Small College Athletic Association (NSCAA)}
\item{NCCAA}{Member of National Christian College Athletic Association (NCCAA)}
\item{AA_NA}{Member of Other, not one of the above associations}
\item{MEM_FOOTBALL}{NCAA or NAIA member for football }
\item{CON_FOOTBALL}{NCAA or NAIA member for football, conference specified (See \code{conference} dataset for more details.)}
\item{MEM_BASKETBALL}{NCAA or NAIA member for basketball }
\item{CON_BASKETBALL}{NCAA or NAIA member for basketball, conference specified (See \code{conference} dataset for more details.)}
\item{MEM_BASEBALL}{NCAA or NAIA member for baseball }
\item{CON_BASEBALL}{NCAA or NAIA member for baseball, conference specified (See \code{conference} dataset for more details.)}
\item{MEM_TRACK}{NCAA or NAIA member for cross country/track}
\item{CON_TRACK}{NCAA or NAIA member for cross country/track, conference specified (See \code{conference} dataset for more details.)}
}
}
\source{
Download from Integrated Postsecondary Education Data System,
\url{https://nces.ed.gov/ipeds/datacenter/data/IC2020.zip}.
}
\usage{
offerings2020
}
\description{
This file contains data on program and award level offerings, control and affiliation of institution. It also contains information on special learning opportunities, student services, disability services, tuition plans and athletic conference associations. Services and programs for service members and veterans are also included.
}
\details{
Provisional release data have undergone all NCES data quality control procedures. Data are imputed for nonresponding institutions.

Note: Unless otherwise defined, 1 = Yes; 0 = Implied No; -1 = Not Reported; and -2 = Not Applicable
}
\keyword{datasets}
