% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_analysis.R
\name{irt_vis}
\alias{irt_vis}
\title{irt_vis}
\usage{
irt_vis(d, T_out, sub_name = NULL, out_file = NULL)
}
\arguments{
\item{d}{The number of latent dimensions}

\item{T_out}{N x (d+z) data frame with average latent dimensions in first d columns}

\item{sub_name}{The name of a variable in T_out used for levels in the plot (Default = NULL)}

\item{out_file}{Output file name for plot (Default = NULL)}
}
\value{
A ggplot2 object containing density ridge plots of the latent dimensions. When sub_name is NULL, the plot shows the distribution of each theta dimension. When sub_name is provided, the plot shows distributions faceted by theta dimension and grouped by the specified variable.
}
\description{
Takes as input the number of latent dimensions (d),
an N x (d+z) data frame with average thetas in the first d columns and variables not included in the
calculation of the thetas in the rest (T_out), and, optionally, a variable name (sub_name)
taken from T_out, and an output file name (out_file),
and returns either unconditional theta distributions or distributions subset by that variable
}
