% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.R
\name{phi.extremes}
\alias{phi.extremes}
\title{Relevance function for extreme target values}
\usage{
phi.extremes(
  y,
  extr.type = c("both", "high", "low"),
  coef = 1.5,
  asym = TRUE,
  ...
)
}
\arguments{
\item{y}{The target variable of a given data set}

\item{extr.type}{Type of extremes to be considered: low, high or both (default)}

\item{coef}{Boxplot coefficient (default 1.5)}

\item{asym}{Boolean for assymetric interpolation. Default TRUE, uses adjusted boxplot. When FALSE, uses standard boxplot.}

\item{...}{Additional parameters}
}
\value{
A list with three slots with information concerning the relevance function
\item{method}{The method used to generate the relevance function (extremes or range)}
\item{npts}{?}
\item{control.pts}{Three sets of values identifying the target value-relevance-derivate for the first low extreme value, the median, and first high extreme value}
}
\description{
Automatic approach to obtain a relevance function for a given target variable when the option of extremes is chosen, i.e. users are more interested in accurately predicting extreme target values
}
\keyword{internal}
