/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;

class DelegateDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix2D content;
    protected int row;

    public DelegateDComplexMatrix1D(DComplexMatrix2D dComplexMatrix2D, int n) {
        if (n < 0 || n >= dComplexMatrix2D.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(dComplexMatrix2D.columns());
        this.row = n;
        this.content = dComplexMatrix2D;
    }

    public synchronized double[] getQuick(int n) {
        return this.content.getQuick(this.row, n);
    }

    public DComplexMatrix1D like(int n) {
        return this.content.like1D(n);
    }

    public DComplexMatrix2D like2D(int n, int n2) {
        return this.content.like(n, n2);
    }

    public synchronized void setQuick(int n, double[] dArray) {
        this.content.setQuick(this.row, n, dArray);
    }

    public synchronized void setQuick(int n, double d, double d2) {
        this.content.setQuick(this.row, n, d, d2);
    }

    public Object elements() {
        return this.content.elements();
    }

    public DComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public DoubleMatrix1D getImaginaryPart() {
        return this.content.viewRow(this.row).getImaginaryPart();
    }

    public DoubleMatrix1D getRealPart() {
        return this.content.viewRow(this.row).getRealPart();
    }
}

