% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inquilab.R
\name{second_order_kinetics}
\alias{second_order_kinetics}
\title{Calculate Second Order Kinetics Parameters}
\usage{
second_order_kinetics(t, c)
}
\arguments{
  \item{t}{Numeric vector, time points.}
  \item{c}{Numeric vector, concentrations corresponding to each time point.}
}
\description{
This function calculates the rate constant and half-life based on second-order dissipation kinetics of pesticides,
and provides a summary of the kinetic model including intercept, R-squared value, and other statistical measures.
}
\details{
The function first checks if the concentration values are greater than zero and if the length of the time and concentration vectors are equal. It then transforms the concentration data for second-order kinetics analysis and fits a linear model to the transformed data. From the fitted model, it calculates the rate constant and the half-life of the reaction. Finally, it provides a summary of the kinetic model, including the intercept, R-squared value, and other statistical measures.
}
\examples{
t <- c(0, 5, 10, 15, 20, 25)
c <- c(100, 80, 60, 40, 20, 10)
second_order_kinetics(t, c)
}
\value{
A list containing the following components:
  \item{rate constant}{The calculated rate constant for the first-order kinetics.}
  \item{half life}{The calculated half-life based on the rate constant and initial concentration.}
  \item{summary}{A summary object providing statistical measures of the fitted model, including the intercept, R^2 value, among others.}
}
\seealso{
  \code{\link[stats]{lm}}, for details on the linear models used within.
}
\keyword{models}
\keyword{statistics}

