% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hdchangeseq.R
\name{plot.hdchangeseq}
\alias{plot.hdchangeseq}
\title{Plot function for 'hdchangeseq' class}
\usage{
\method{plot}{hdchangeseq}(x, noise = TRUE, shuffle = FALSE, ...)
}
\arguments{
\item{x}{An object of 'hdchangeseq' class}

\item{noise}{If noise == TRUE, the data matrix is plotted, otherwise, only the mean structure is plotted.}

\item{shuffle}{Whether to shuffle the rows of the plotted matrix.}

\item{...}{Other graphical parameters are not used.}
}
\description{
Visualising the high-dimensional time series in an 'hdchangeseq' class object. The data matrix or its mean structure is visualised using a grid of coloured rectangles with colours corresponding to the value contained in corresponding coordinates. A heat-spectrum (red to white for values low to high) is used to convert values to colours.
}
\examples{
n <- 2000; p <- 200; ks <- 40; zs <- c(500,1000,1500)
varthetas <- c(0.1,0.15,0.2); overlap <- 0.5
obj <- multi.change(n, p, ks, zs, varthetas, overlap)
plot(obj, noise = TRUE)
}
