% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.ccurve}
\alias{draw.ccurve}
\title{Draw a calibration curve.}
\usage{
draw.ccurve(
  cal1 = -50,
  cal2 = 55000,
  cc1 = "IntCal20",
  cc2 = NA,
  cc1.postbomb = FALSE,
  cc2.postbomb = FALSE,
  BCAD = FALSE,
  cal.lab = NA,
  cal.rev = FALSE,
  c14.lab = NA,
  c14.lim = NA,
  c14.rev = FALSE,
  ka = FALSE,
  add.yaxis = FALSE,
  cc1.col = rgb(0, 0, 1, 0.5),
  cc1.fill = rgb(0, 0, 1, 0.2),
  cc2.col = rgb(0, 0.5, 0, 0.5),
  cc2.fill = rgb(0, 0.5, 0, 0.2),
  add = FALSE,
  bty = "l",
  ccdir = NULL,
  ...
)
}
\arguments{
\item{cal1}{First calendar year for the plot}

\item{cal2}{Last calendar year for the plot}

\item{cc1}{Name of the calibration curve. Can be "IntCal20", "Marine20", "SHCal20", or for the previous curves "IntCal13", "Marine13" or "SHCal13". Can also be "nh1", "nh2", "nh3", "sh1-2", "sh3", "nh1_monthly", "nh1_monthly", "nh2_monthly", "nh3_monthly", "sh1-2_monthly", "sh3_monthly", "Kure", "LevinKromer" or "Santos" for postbomb curves.}

\item{cc2}{Optional second calibration curve to plot. Can be "IntCal20", "Marine20", "SHCal20", or for the previous curves "IntCal13", "Marine13" or "SHCal13". Defaults to nothing, NA.}

\item{cc1.postbomb}{Use \code{postbomb=TRUE} to get a postbomb calibration curve for cc1 (default \code{cc1.postbomb=FALSE}).}

\item{cc2.postbomb}{Use \code{postbomb=TRUE} to get a postbomb calibration curve for cc2 (default \code{cc2.postbomb=FALSE}).}

\item{BCAD}{The calendar scale of graphs and age output-files is in cal BP (calendar or calibrated years before the present, where the present is AD 1950) by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{cal.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}), or to \code{age.lab="kcal BP"} etc. if ka=TRUE.}

\item{cal.rev}{Reverse the calendar axis.}

\item{c14.lab}{Label for the C-14 axis. Defaults to 14C BP (or 14C kBP if ka=TRUE).}

\item{c14.lim}{Axis limits for the C-14 axis. Calculated automatically by default.}

\item{c14.rev}{Reverse the C-14 axis.}

\item{ka}{Use kcal BP (and C14 kBP).}

\item{add.yaxis}{Whether or not to plot the second calibration. Defaults to \code{add.yaxis=FALSE}.}

\item{cc1.col}{Colour of the calibration curve (outline).}

\item{cc1.fill}{Colour of the calibration curve (fill).}

\item{cc2.col}{Colour of the calibration curve (outline), if activated (default cc2=NA).}

\item{cc2.fill}{Colour of the calibration curve (fill), if activated (default cc2=NA).}

\item{add}{Whether or not to add the curve(s) to an existing plot. Defaults to FALSE, which draws a new plot}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="l"}.}

\item{ccdir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{ccdir="curves"}.}

\item{...}{Any additional optional plotting parameters.}
}
\value{
The calibration curve (invisible).
}
\description{
Draw one or two of the calibration curves, or add a calibration curve to an existing plot.
}
\examples{
draw.ccurve()
draw.ccurve(1000, 3000, cc2="Marine20")
draw.ccurve(1800, 2020, BCAD=TRUE, cc2="nh1", cc2.postbomb=TRUE)
draw.ccurve(1800, 2010, BCAD=TRUE, cc2="nh1", add.yaxis=TRUE)
}
