% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{rectifyIrho}
\alias{rectifyIrho}
\title{Rectify I using a correlation method for all the variables in an input file.}
\usage{
rectifyIrho(data, samples = 10000)
}
\arguments{
\item{data}{the data frame obtained from \code{loadFile}.}

\item{samples}{number of permutations for the resampling method.}
}
\value{
An object with I, rescaleI and statistic summary for the inputs without scaling, the same statistics after scaling them, the p-value and the convexhull information
}
\description{
\code{rescaleI} It executes the whole rectifying using theorical R distribution for all the measurements in the csv file.
\itemize{
\item It plots the histogram with the theorical distribution.
\item It plots the convexHull for each variable.
\item It calcualtes the area and centroid of the convex hull for each variable.
\item It calculates the I and rescale it for every variable.
\item It returns an object with the computations.
}
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data <- loadFile(fileInput)
rectifiedI<-rectifyIrho(data,100)
}
