% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors.R
\name{predictors}
\alias{predictors}
\title{Create a table of \code{predictors}}
\usage{
predictors(df, verbose = FALSE)
}
\arguments{
\item{df}{input data frame, with columns:
\describe{
\item{pred}{String specifying the name of the predictor, e.g. "temp" or
"host_den"}
\item{pred_subcategory}{This column allows specifying predictors for which
there are multiple values for a given j_day. Predictor values are sorted by
this column in the config set up. This ensures that when accessing a
predictor with multiple values for the same j_day, we get a vector of
predictor values ordered by this column. A typical use for this column is
to specify the host density of each host species.}
\item{j_day}{Integer specifying the Julian day, or NA for predictors with
constant value over time}
\item{value}{Numeric value of predictor}
}}

\item{verbose}{Boolean; whether to warn about reordering the \code{df}}
}
\value{
a \code{predictors} object
}
\description{
A data frame of input data to be used in as predictor values in transition
functions.
}
