% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo_JSparO.R
\name{demo_JSparO}
\alias{demo_JSparO}
\title{demo_JSparO - The demo of JSparO package}
\usage{
demo_JSparO(A, B, X, s, p, q, maxIter = 200)
}
\arguments{
\item{A}{Gene expression data of transcriptome factors (i.e. feature matrix in machine learning).
The dimension of A is m * n.}

\item{B}{Gene expression data of target genes (i.e. observation matrix in machine learning).
The dimension of B is m * t.}

\item{X}{Gene expression data of Chromatin immunoprecipitation or other matrix
(i.e. initial iterative point in machine learning). The dimension of X is n * t.}

\item{s}{joint sparsity level}

\item{p}{value for \eqn{l_{p,q}} norm (i.e., p = 1 or 2)}

\item{q}{value for \eqn{l_{p,q}} norm (i.e., 0 <= q <= 1)}

\item{maxIter}{maximum iteration}
}
\value{
The solution of proximal gradient method with \eqn{l_{p,q}} regularizer.
}
\description{
This is the main function of JSparO aimed to solve the low-order regularization models with \eqn{l_{p,q}} norm.
}
\details{
The demo_JSparO function is used to solve joint sparse optimization problem via different algorithms.
Based on \eqn{l_{p,q}} norm, functions with different p and q are implemented to solve the problem:
\deqn{\min \|AX-B\|_F^2 + \lambda \|X\|_{p,q}}
to obtain s-joint sparse solution.
}
\examples{
m <- 256; n <- 1024; t <- 5; maxIter0 <- 50
A0 <- matrix(rnorm(m * n), nrow = m, ncol = n)
B0 <- matrix(rnorm(m * t), nrow = m, ncol = t)
X0 <- matrix(0, nrow = n, ncol = t)
res_JSparO <- demo_JSparO(A0, B0, X0, s = 10, p = 2, q = 'half', maxIter = maxIter0)

}
\author{
Xinlin Hu \href{mailto:thompson-xinlin.hu@connect.polyu.hk}{thompson-xinlin.hu@connect.polyu.hk}

Yaohua Hu \href{mailto:mayhhu@szu.edu.cn}{mayhhu@szu.edu.cn}
}
