% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{getArtistsLocation}
\alias{getArtistsLocation}
\title{This method let you select and filter geographical locations which artists have declared as reference for themselves}
\usage{
getArtistsLocation(
  location,
  city = NULL,
  limit = 10,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID")
)
}
\arguments{
\item{location}{The artist country (following ISO 3166_1 standard \url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3#Officially_assigned_code_elements})}

\item{city}{The artist city (optional)}

\item{limit}{Integer to set the number of displayed search results. Maximum value is 200.}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about artist from a certain location.
See \url{https://developer.jamendo.com/v3.0/artists/locations} for more information.
}
\description{
This method let you select and filter geographical locations which artists have declared as reference for themselves
}
\examples{
\donttest{
##Example
 artists <- getArtistsLocation("GRC", limit=3)
}
}
