% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.jaya}
\alias{plot.jaya}
\title{Plot Function for Jaya Algorithm Results}
\usage{
\method{plot}{jaya}(x, ...)
}
\arguments{
\item{x}{An object of class \code{jaya} containing the optimization results from the \code{jaya} function.}

\item{...}{Additional graphical parameters passed to the \code{plot} function.}
}
\description{
This function generates plots for single-objective optimization results from the Jaya algorithm.
It visualizes the best objective function value against the number of iterations.
}
\details{
This function supports plotting results for single-objective optimization.
It creates a plot of the best objective function value observed across iterations.
Ensure that the input object is from the \code{jaya} function.
}
\examples{
# Example: Single-objective optimization
sphere_function <- function(x) sum(x^2)

lower_bounds <- rep(-5, 3)
upper_bounds <- rep(5, 3)
pop_size <- 20
max_iterations <- 50
num_variables <- length(lower_bounds)

# Run optimization
single_result <- jaya(
  fun = sphere_function,
  lower = lower_bounds,
  upper = upper_bounds,
  popSize = pop_size,
  maxiter = max_iterations,
  n_var = num_variables,
  opt = "minimize"
)

# Plot the result
plot(single_result)

}
