% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JdmbsJump.R
\name{jdm_bs}
\alias{jdm_bs}
\title{A Monte Carlo Option Pricing Algorithm for Jump Diffusion Model}
\usage{
jdm_bs(
  day = 180,
  monte_carlo = 1000,
  start_price = start_price,
  mu = mu,
  sigma = sigma,
  lambda = lambda,
  K = K,
  plot = TRUE
)
}
\arguments{
\item{day}{: an integer of a time duration of simulation.}

\item{monte_carlo}{: an integer of an iteration number for monte carlo.}

\item{start_price}{: a vector of company's initial stock prices.}

\item{mu}{: a vector of drift parameters of geometric Brownian motion.}

\item{sigma}{: a vector of volatility parameters of geometric Brownian motion.}

\item{lambda}{: an integer of how many times jump in unit time.}

\item{K}{: a vector of option strike prices.}

\item{plot}{: a logical type of whether plot a result or not.}
}
\value{
option prices : a list of (call_price, put_price)
}
\description{
A Monte Carlo Option Pricing Algorithm for Jump Diffusion Model
}
\examples{
jdm_bs(100,10,c(5500,6500,8000),c(0.1,0.2,0.05),c(0.11,0.115,0.1),2,c(6000,7000,12000),plot=TRUE)
}
