% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPCscoreLSE.R
\name{FPCscoreLSE}
\alias{FPCscoreLSE}
\title{Least square estimates of functional principal component scores}
\usage{
FPCscoreLSE(Lt, Ly, kern, bw, FPC_dis, RegGrid, more = FALSE)
}
\arguments{
\item{Lt}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation time in ascending order for each subject.}

\item{Ly}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the measurements of each subject at the observation time correspond to \code{Lt}.}

\item{kern}{A \code{character} denoting the kernel type; 'epan'(Epanechnikov), 'unif'(Uniform), 'quar'(Quartic), 'gauss'(Gaussian).}

\item{bw}{A scalar denoting the bandwidth for mean function estimate.}

\item{FPC_dis}{A \code{nRegGrid} by \code{nK} \code{matrix} containing the eigenfunction estimates at \code{RegGrid}, where \code{nRegGrid} is the length of \code{RegGrid} and \code{nK} is the number of FPCs.}

\item{RegGrid}{A \code{vector} of the equally spaced time points in the support interval.}

\item{more}{Logical; If \code{FALSE}, only the estimates of FPC scores are returned. If \code{TRUE}, the mean function estimates and the eigenfunction estimates at all observation time points are also returned.}
}
\value{
If \code{more = FALSE}, a \emph{n} by \code{nK} \code{matrix} containing the estimates of the FPC scores is returned, where \emph{n} is the sample size. If \code{more = TRUE}, a \code{list} containing the following components is returned:
\item{score}{a \emph{n} by \code{nK} \code{matrix} containing the estimates of the FPC scores.}
\item{meanest_fine}{Mean function estimates at all observation time points.}
\item{FPC_dis_fine}{Eigenfunction estimates at all observation time points.}
}
\description{
Least square estimates (LSE) of functional principal component scores.
}
\examples{
# Generate data
n <- 100
interval <- c(0, 10)
lambda_1 <- 9 #the first eigenvalue
lambda_2 <- 1.5 #the second eigenvalue
eigfun <- list()
eigfun[[1]] <- function(x){cos(pi * x/10)/sqrt(5)}
eigfun[[2]] <- function(x){sin(pi * x/10)/sqrt(5)}
score <- cbind(rnorm(n, 0, sqrt(lambda_1)), rnorm(n, 0, sqrt(lambda_2)))
DataNew <- GenDataKL(n, interval = interval, sparse = 3:5, regular = FALSE,
                     meanfun = function(x){0}, score = score,
                     eigfun = eigfun, sd = sqrt(0.1))
basis <- fda::create.bspline.basis(interval, nbasis = 13, norder = 4,
                              breaks = seq(0, 10, length.out = 11))
Klist <- KFPCA(DataNew$Lt, DataNew$Ly, interval, nK = 2, bw = 1,
               nRegGrid = 51, fdParobj = basis)
# Just an example to explain the use of FPCscoreLSE().
# One can obtain FPC scores estimates for KFPCA method
# by KFPCA() directly. Note that FPCscoreLSE() can also be used
# to estimate FPC scores for methods except KFPCA.
scoreKFPCA <- FPCscoreLSE(DataNew$Lt, DataNew$Ly, kern = "epan",
                          bw = Klist$bwmean, FPC_dis = Klist$FPC_dis,
                          RegGrid = seq(interval[1], interval[2], length.out = 51))
}
