% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRhsip.R
\name{LRhsip}
\alias{LRhsip}
\title{LR in half-sibling identification with the identical parent participated}
\usage{
LRhsip(A, B, P, af, rare = 1e-04, allelename = FALSE, phi = 0.5)
}
\arguments{
\item{A}{Genotype data of the first sibling, should be data.frame with 2 columns and ss rows, where ss stand for sample size;}

\item{B}{Genotype data of the second sibling, with the same form with \code{A}}

\item{P}{Genotype data of the identical parent of \code{A} and \code{B}, with the same form with them}

\item{af}{name of allele frequency matrix, a data.frame of 1 column containing frequencies with allele names being row names}

\item{rare}{frequency of rare allele on the locus}

\item{allelename}{if TRUE, the input genotype data would be regarded as allelenames, otherwise, the position in the af matrix}

\item{phi}{kinship coefficient of the other parents of the two siblings under Hp, with default of 1/2, i.e, being identical or MZ}
}
\value{
a data frame with one column and ss rows, containing log10 value of the CLR of each case
}
\description{
LR when a pair of siblings and one of their identical parent participated, Hp and Hd of which being "the other parents of the two siblings being specific related" and "the other parents of them being unrelated". Inbreeding factors are not taken into consideration.
}
\details{
Mutation might be found between P with A or B, if so, LR would be output as 1-phi, which can be further optimized in the future version.
}
\examples{
# Construct pedi data.frames for two types of pedigrees
pedi1 <- data.frame(Person=c("F","M","A","B"),
                    Father=c("RI","RI","F","F"),
                    Mother=c("RI","RI","M","M"))
pedi2 <- data.frame(Person=c("M","A","B"),
                    Father=c("RI","RI","RI"),
                    Mother=c("RI","M","M"))
LR_1=LR_2=data.frame(Log10CLR=rep(0,10000))
for (i in 1:42) {
  # Simulate 10000 groups of A/B/P where A is full sibiling of B
  Genotype1=pedisimu(af = FortytwoSTR$afmatrix[[i]],ss = 10000,pedi = pedi1)
  LR_1=LR_1+LRhsip(A=Genotype1[,5:6],B=Genotype1[,7:8],P=Genotype1[,3:4],
                   af = FortytwoSTR$afmatrix[[i]],rare=FortytwoSTR$rare[i][1,1])
  # Simulate 10000 groups of A/B/P where A is half sibling of B, i.e., the true phi=0
  Genotype2=pedisimu(af = FortytwoSTR$afmatrix[[i]],ss = 10000,pedi = pedi2)
  LR_2=LR_2+LRhsip(A=Genotype2[,3:4],B=Genotype2[,5:6],P=Genotype2[,1:2],
                   af = FortytwoSTR$afmatrix[[i]],rare=FortytwoSTR$rare[i][1,1])
}
# histograms of CLR distributions in the two groups
xmin<-floor(min(min(LR_1$Log10CLR),min(LR_2$Log10CLR)))
xmax<-ceiling(max(max(LR_1$Log10CLR),max(LR_2$Log10CLR)))
par(mfrow = c(1, 2))
hist(LR_2$Log10CLR,xlab = expression(log[10]~CLR),main = "False pedigree",
     xlim = c(xmin,xmax), col = "red")
hist(LR_1$Log10CLR,xlab = expression(log[10]~CLR),main = "True cases",
     xlim = c(xmin,xmax), col = "blue")

}
