% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadFamFile.R
\name{loadFamFile}
\alias{loadFamFile}
\title{Load \code{.fam} file}
\usage{
loadFamFile(path, fallbackModel = "equal", withParams = FALSE)
}
\arguments{
\item{path}{The path to a \code{.fam} file.}

\item{fallbackModel}{The name of a mutation model; passed on to
\code{\link[pedFamilias:readFam]{pedFamilias::readFam()}}.}

\item{withParams}{A logical indicating if the Familias parameters should be
included in the output. (See \code{\link[pedFamilias:readFam]{pedFamilias::readFam()}}.)}
}
\value{
A list of two \code{ped} objects.
}
\description{
Load \code{.fam} file
}
\examples{
fam = system.file("extdata/halfsib-test.fam", package = "KLINK")
peds = loadFamFile(fam)
pedtools::plotPedList(peds)

}
