% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmm.R
\name{gmm}
\alias{gmm}
\title{Returns a Gaussian Mixture Model}
\usage{
gmm(nComp = NULL, mu = NULL, sigma = NULL, weights = NULL, d = NULL)
}
\arguments{
\item{nComp}{(scalar) : number of components}

\item{mu}{(d by k): mean of each component}

\item{sigma}{(d by d by k): covariance of each component}

\item{weights}{(1 by k) : mixing weight of each proportion (optional)}

\item{d}{: number of dimensions of vector (optional)}
}
\value{
model : A Gaussian Mixture Model generated from the given parameters
}
\description{
Returns a Gaussian Mixture Model
}
\examples{
# Default 1-d gaussian mixture model
model <- gmm()

# 1-d Gaussian mixture model with 3 components
model <- gmm(nComp = 3)

# 3-d Gaussian mixture model with 3 components, with specified mu,sigma and weights
mu <- matrix(c(1,2,3,2,3,4,5,6,7),ncol=3)
sigma <- array(diag(3),c(3,3,3))
model <- gmm(nComp = 3, mu = mu, sigma=sigma, weights = c(0.2,0.4,0.4), d = 3)
}
