% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvfit.R
\name{L0Learn.cvfit}
\alias{L0Learn.cvfit}
\title{Cross Validation}
\usage{
L0Learn.cvfit(
  x,
  y,
  loss = "SquaredError",
  penalty = "L0",
  algorithm = "CD",
  maxSuppSize = 100,
  nLambda = 100,
  nGamma = 10,
  gammaMax = 10,
  gammaMin = 1e-04,
  partialSort = TRUE,
  maxIters = 200,
  rtol = 1e-06,
  atol = 1e-09,
  activeSet = TRUE,
  activeSetNum = 3,
  maxSwaps = 100,
  scaleDownFactor = 0.8,
  screenSize = 1000,
  autoLambda = NULL,
  lambdaGrid = list(),
  nFolds = 10,
  seed = 1,
  excludeFirstK = 0,
  intercept = TRUE,
  lows = -Inf,
  highs = Inf
)
}
\arguments{
\item{x}{The data matrix.}

\item{y}{The response vector. For classification, we only support binary vectors.}

\item{loss}{The loss function. Currently we support the choices "SquaredError" (for regression), "Logistic" (for logistic regression), and "SquaredHinge" (for smooth SVM).}

\item{penalty}{The type of regularization. This can take either one of the following choices:
"L0", "L0L2", and "L0L1".}

\item{algorithm}{The type of algorithm used to minimize the objective function. Currently "CD" and "CDPSI" are
are supported. "CD" is a variant of cyclic coordinate descent and runs very fast. "CDPSI" performs
local combinatorial search on top of CD and typically achieves higher quality solutions (at the expense
of increased running time).}

\item{maxSuppSize}{The maximum support size at which to terminate the regularization path. We recommend setting
this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small
portion of non-zeros.}

\item{nLambda}{The number of Lambda values to select (recall that Lambda is the regularization parameter
corresponding to the L0 norm). This value is ignored if 'lambdaGrid' is supplied.}

\item{nGamma}{The number of Gamma values to select (recall that Gamma is the regularization parameter
corresponding to L1 or L2, depending on the chosen penalty). This value is ignored if 'lambdaGrid' is supplied 
and will be set to length(lambdaGrid)}

\item{gammaMax}{The maximum value of Gamma when using the L0L2 penalty. For the L0L1 penalty this is
automatically selected.}

\item{gammaMin}{The minimum value of Gamma when using the L0L2 penalty. For the L0L1 penalty, the minimum
value of gamma in the grid is set to gammaMin * gammaMax. Note that this should be a strictly positive quantity.}

\item{partialSort}{If TRUE partial sorting will be used for sorting the coordinates to do greedy cycling (see our paper for
for details). Otherwise, full sorting is used.}

\item{maxIters}{The maximum number of iterations (full cycles) for CD per grid point.}

\item{rtol}{The relative tolerance which decides when to terminate optimization (based on the relative change in the objective between iterations).}

\item{atol}{The absolute tolerance which decides when to terminate optimization (based on the absolute L2 norm of the residuals).}

\item{activeSet}{If TRUE, performs active set updates.}

\item{activeSetNum}{The number of consecutive times a support should appear before declaring support stabilization.}

\item{maxSwaps}{The maximum number of swaps used by CDPSI for each grid point.}

\item{scaleDownFactor}{This parameter decides how close the selected Lambda values are. The choice should be
strictly between 0 and 1 (i.e., 0 and 1 are not allowed). Larger values lead to closer lambdas and typically to smaller
gaps between the support sizes. For details, see our paper - Section 5 on Adaptive Selection of Tuning Parameters).}

\item{screenSize}{The number of coordinates to cycle over when performing initial correlation screening.}

\item{autoLambda}{Ignored parameter. Kept for backwards compatibility.}

\item{lambdaGrid}{A grid of Lambda values to use in computing the regularization path. This is by default an empty list and is ignored.
When specified, LambdaGrid should be a list of length 'nGamma', where the ith element (corresponding to the ith gamma) should be a decreasing sequence of lambda values
which are used by the algorithm when fitting for the ith value of gamma (see the vignette for details).}

\item{nFolds}{The number of folds for cross-validation.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{excludeFirstK}{This parameter takes non-negative integers. The first excludeFirstK features in x will be excluded from variable selection,
i.e., the first excludeFirstK variables will not be included in the L0-norm penalty (they will still be included in the L1 or L2 norm penalties.).}

\item{intercept}{If FALSE, no intercept term is included in the model.}

\item{lows}{Lower bounds for coefficients. Either a scalar for all coefficients to have the same bound or a vector of size p (number of columns of X) where lows[i] is the lower bound for coefficient i.}

\item{highs}{Upper bounds for coefficients. Either a scalar for all coefficients to have the same bound or a vector of size p (number of columns of X) where highs[i] is the upper bound for coefficient i.}
}
\value{
An S3 object of type "L0LearnCV" describing the regularization path. The object has the following members.
\item{cvMeans}{This is a list, where the ith element is the sequence of cross-validation errors corresponding to the ith gamma value, i.e., the sequence
cvMeans[[i]] corresponds to fit$gamma[i]}
\item{cvSDs}{This a list, where the ith element is a sequence of standard deviations for the cross-validation errors: cvSDs[[i]] corresponds to cvMeans[[i]].}
\item{fit}{The fitted model with type "L0Learn", i.e., this is the same object returned by \code{\link{L0Learn.fit}}.}
}
\description{
Computes a regularization path and performs K-fold cross-validation.
}
\examples{
# Generate synthetic data for this example
data <- GenSynthetic(n=100,p=20,k=10,seed=1)
X = data$X
y = data$y
#'
# Perform 3-fold cross-validation on an L0L2 regression model with 3 values of
# Gamma ranging from 0.0001 to 10
fit <- L0Learn.cvfit(X, y, nFolds=3, seed=1, penalty="L0L2", maxSuppSize=20, nGamma=3,
gammaMin=0.0001, gammaMax = 10)
print(fit)
# Plot the graph of cross-validation error versus lambda for gamma = 0.0001
plot(fit, gamma=0.0001)
# Extract the coefficients at lambda = 0.0361829 and gamma = 0.0001
coef(fit, lambda=2.45513e-02, gamma=0.0001)
# Apply the fitted model on X to predict the response
predict(fit, newx = X, lambda=2.45513e-02, gamma=0.0001)

}
