% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invL0TF.R
\name{L0TFinv.fix}
\alias{L0TFinv.fix}
\title{The inverse L0 trend filtering with fixed change points}
\usage{
L0TFinv.fix(y = y, k = k, q = q, first = 0, last = 1)
}
\arguments{
\item{y}{The input data points}

\item{k}{The given number of change points}

\item{q}{0 or 1. Correspond to a piecewise constant or piecewise linear trend}

\item{first}{The value ranges from 0 to 1. Represent the minimum percentile point where a change point may occur. If 'first' = 0.01, it means that change points cannot appear in the first 1\% of the data points. If 'first' = 0, there is no constraint on the position of the change point.}

\item{last}{The value ranges from 0 to 1. Represent the maximum percentile point where a change point may occur. If 'last' = 0.99, it means that change points cannot appear in the last 1\% of the data points. If 'last' = 1, there is no constraint on the position of the change point.}
}
\value{
An S3 object of type "L0TFinvfix". A list containing the fitted trend results:
\item{sic}{Information criterion value with a penalty term of \eqn{2\log(\log(n)) \times \log(n)}}
\item{bic}{Information criterion value with a penalty term of \eqn{2 \times \log(n)}}
\item{mse}{The mean square error between the fitted trend and the input data}
\item{y}{The input data points}
\item{betak}{The fitted \eqn{\hat{\boldsymbol{\beta}}} coefficients with the number of change points being \eqn{k} }
\item{yk}{The fitted trend with the number of change points being \eqn{k}}
\item{Ak}{The set of position indicators of the fitted change points with the number of change points being \eqn{k}}
\item{beta.all}{A data frame with dimensions \eqn{n \times k}, where each column represents the fitted \eqn{\hat{\boldsymbol{\beta}}} coefficients corresponding to a given number of change points}
\item{y.all}{A data frame with dimensions \eqn{n \times k}, where each column represents the fitted estimated trend corresponding to a given number of change points}
\item{A.all}{A list of length \eqn{k}, where each element corresponds to the set of position indicators of change points under a given number }
}
\description{
Fit the input data points to a piecewise constant or piecewise linear trend with a given number of change points.
}
\examples{
tau = c(0.1, 0.3, 0.4, 0.7, 0.85)
h = c(-1, 5, 3, 0, -1, 2)
BlocksData <- SimuBlocksInv(n = 350, sigma = 0.2, seed = 50, tau = tau ,h = h)
res <- L0TFinv.fix(y=BlocksData$y, k=5, q=0, first=0.01, last=1)
print(res$Ak)
print(BlocksData$setA)
plot(BlocksData$x, BlocksData$y, xlab="", ylab="")
lines(BlocksData$x, BlocksData$y0, col = "red")
lines(BlocksData$x, res$yk, col = "lightgreen")

tau1 = c(0.1, 0.3, 0.4, 0.7, 0.85)
h1 = c(-1, 5, 3, 0, -1, 2)
a0 = -10
WaveData <- SimuWaveInv(n = 2000, sigma = 0.1, seed = 50, tau = tau1, h = h1, a0 = a0)
res1 <- L0TFinv.fix(y=WaveData$y, k=5, q=1, first=0, last=0.99)
print(res1$Ak)
print(WaveData$setA)
plot(WaveData$x, WaveData$y, xlab="", ylab="")
lines(WaveData$x, WaveData$y0, col = "red")
lines(WaveData$x, res1$yk, col = "lightgreen")

}
\seealso{
\code{\link{L0TFinv.opt}}
}
