% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLAD.R
\name{calcLAD}
\alias{calcLAD}
\title{Calculate summary statistics from measured leaf inclination angles}
\arguments{
\item{data}{Dataframe. The dataframe containing leaf inclination angle measurements.}

\item{angles}{Numeric. The column containing leaf inclination angle measurements (in degrees).}

\item{type}{Character. If set to "summary", it gives summary distributions. If set to "extended", it calculates LAD probability density (pdf) and G-function (G) for view or inclination angles (theta). Default set to "summary".}

\item{...}{The column(s) indicating the grouping variables to be considered for calculating summary statistics.}
}
\value{
A dataframe with the grouping variable(s), and:
\itemize{
\item summary statistics (MTA, SD, N, mu, nu, distribution) in case of type="summary";
\item LAD (pdf) and G-function (G) in case of type="extended".
}
}
\description{
The function derives summary statistics from measured leaf inclination angles:.
\itemize{
\item Mean (MTA), standard deviation (SD) and frequency (NR) observations.
\item The two (mu, nu) Beta parameters derived from the formula provided by Goel and Strebel (1984) \doi{10.2134/agronj1984.00021962007600050021x}.
\item The distribution type, comparing the distribution against the six theoretical LAD distributions provided by \href{https://library.wur.nl/WebQuery/wurpubs/413358}{de Wit (1965)}.
}
}
\examples{
head(Chianucci)
\donttest{
calcLAD(Chianucci,Angle_degree,type='summary',Genus,Species)
calcLAD(Chianucci,Angle_degree,type='extended',Genus,Species)
}

}
