% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{individual_later_fit}
\alias{individual_later_fit}
\title{Fit individual LATER model to each dataset in a dataframe of datasets}
\usage{
individual_later_fit(
  df,
  with_early_component = FALSE,
  fit_criterion = "likelihood",
  jitter_settings = list(n = 7, prop = 0.5, seed = NA, processes = 2)
)
}
\arguments{
\item{df}{A dataframe with columns: \code{time}, \code{name}, \code{promptness}, and \code{e_cdf}}

\item{with_early_component}{If \code{TRUE}, the model contains a second 'early'
component that is absent when \code{FALSE} (the default).}

\item{fit_criterion}{String indicating the criterion used to optimise the
fit by seeking its minimum.
\itemize{
\item \code{ks}: Kolmogorov-Smirnov statistic.
\item \code{neg_loglike}: Negative log-likelihood.
}}

\item{jitter_settings}{Settings for running the fitting multiple times with
randomly-generated offsets ('jitter') applied to the starting estimates.
\itemize{
\item \code{n}: How many jitter iterations to run (default of 7).
\item \code{prop}: The maximum jitter offset, as a proportion of the start
value (default of 0.5).
\item \code{seed}: Seed for the random jitter generator (default is unseeded).
\item \code{processes}: Maximum number of CPU processes that can be used (default
is 2).
}}
}
\value{
A dataframe with one row for each named dataset in \code{df} and columns
equal to the LATER model parameters returned by fit_data$named_fit_params
}
\description{
Fit individual LATER model to each dataset in a dataframe of datasets
}
\examples{
\donttest{
data <- rbind(
  data.frame(name = "test", promptness = rnorm(100, 3, 1)),
  data.frame(name = "test_2", promptness = rnorm(100, 1, 1))
)
fit_params <- individual_later_fit(data)
}
}
