% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13_HOMOGENEITY.R
\name{homogeneity}
\alias{homogeneity}
\title{Testing homogeneity of the LGD rating model}
\usage{
homogeneity(
  app.port,
  loss,
  pools,
  segment,
  segment.num,
  method = "t.test",
  alpha = 0.05
)
}
\arguments{
\item{app.port}{Application portfolio (data frame) which contains at lease realized loss (LGD),
pools in use and variable used as a segment.}

\item{loss}{Name of the column that represents realized loss (LGD).}

\item{pools}{Name of the column that represents LGD pools.}

\item{segment}{Name of the column that represent testing segments. If it is of numeric type, than it is first grouped
into \code{segment.num} of groups otherwise is it used as supplied.}

\item{segment.num}{Number of groups used for numeric variables supplied as a segment. Only applicable if \code{segment}
is of numeric type.}

\item{method}{Statistical test. Available options are \code{t.test} (default) and \code{wilcox.test}.}

\item{alpha}{Significance level of statistical test. Default is 0.05.}
}
\value{
The command \code{homogeneity} returns a data frame with the following columns:
\itemize{
\item segment.var: Variable used as a segment.
\item pool: Unique values of pools from application portfolio..
\item segment.mod: Tested segment modality. Average realized loss from this segment is compared with
average realized loss from the rest of the modalities within the each rating.
\item no: Number of observations in the analyzed pool.
\item avg: Average realized loss in the analyzed pool.
\item avg.segment: Average realized loss per analyzed segment modality within certain pool.
\item avg.rest: Average realized loss of the rest of segment modalities within certain pool.
\item no.segment: Number of observations of the analyzed segment modality.
\item no.rest: Number of observations of the rest of the segment modalities.
\item p.val: Two proportion test (two sided) p-value.
\item alpha: Selected significance level.
\item res: Accepted hypothesis.
}
}
\description{
\code{homogeneity} performs homogeneity testing of LGD model based on the rating pools and selected segment.
This test is usually applied on application portfolio, but it can be applied also on model development sample.
Additionally, this method requires higher number of observations per segment modalities within each rating in order
to produce available results. For segments with less than 30 observations, test is not performed.
}
\details{
Testing procedure is implemented for each rating separately comparing average realized loss from one segment modality to
the average realized loss from the rest of segment modalities.
}
\examples{
library(monobin)
library(LGDtoolkit)
data(lgd.ds.c)
#build dummy model
rf <- c("rf_01", "rf_02", "rf_16", "rf_03", "rf_09")
for   (i in 1:length(rf)) {
     rf_l <- rf[i]
     lgd.ds.c[, rf_l] <- sts.bin(x = lgd.ds.c[, rf_l], 
                                y = lgd.ds.c[, "lgd"])[[2]]	
     }
str(lgd.ds.c)
frm <- paste0("lgd ~ ", paste(rf, collapse = " + "))
model <- lm(formula = as.formula(frm), data = lgd.ds.c)
summary(model)$coefficients
#create lgd pools
lgd.ds.c$pred <- unname(predict(model))
lgd.ds.c$pool <- sts.bin(x = lgd.ds.c$pred, 
                        y = lgd.ds.c$lgd)[[2]]
#test homogeneity on development sample
#(the same procedure can be applied on application portfolio)
homogeneity(app.port = lgd.ds.c, 
           loss = "lgd", 
           pools = "pool", 
           segment = "rf_03", 
           segment.num = 3, 
           method = "t.test", 
           alpha = 0.05)
}
