% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LKTfunctions.R
\name{LKT_HDI}
\alias{LKT_HDI}
\title{LKT_HDI}
\usage{
LKT_HDI(
  dat,
  n_boot,
  n_students,
  comps,
  feats,
  conns = rep("+", max(1, length(comps) - 1)),
  ints = NA,
  fixeds,
  get_hdi = TRUE,
  cred_mass = 0.95
)
}
\arguments{
\item{dat}{Dataframe}

\item{n_boot}{Number of subsamples to fit}

\item{n_students}{Number of students per subsample}

\item{comps}{Components in model}

\item{feats}{Features in model}

\item{conns}{R notation for linear equation connectors in model}

\item{ints}{Interacts in model}

\item{fixeds}{Fixed parameters in model}

\item{get_hdi}{Boolean to decide if generating HDI per coefficient}

\item{cred_mass}{Credibility mass parameter to decide width of HDI}
}
\value{
List of values "par_reps", "mod_full", "coef_hdi"
}
\description{
Bootstrap credibility intervals to aid in interpreting coefficients.
}
