% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R, R/plot.R
\name{autoplot.lmm}
\alias{autoplot.lmm}
\alias{plot.lmm}
\title{Graphical Display For Linear Mixed Models}
\usage{
\method{autoplot}{lmm}(
  object,
  type = "fit",
  type.residual = NULL,
  obs.alpha = 0,
  obs.size = NULL,
  facet = NULL,
  facet_nrow = NULL,
  facet_ncol = NULL,
  scales = "fixed",
  labeller = "label_value",
  at = NULL,
  time.var = NULL,
  color = NULL,
  position = NULL,
  ci = TRUE,
  ci.alpha = NULL,
  ylim = NULL,
  mean.size = c(3, 1),
  size.text = 16,
  position.errorbar = "identity",
  ...
)

\method{plot}{lmm}(x, ...)
}
\arguments{
\item{object, x}{a \code{lmm} object.}

\item{type}{[character] the type of plot \itemize{
\item \code{"fit"}: fitted values over repetitions.
\item \code{"qqplot"}: quantile quantile plot of the normalized residuals
\item \code{"correlation"}: residual correlation over repetitions
\item \code{"scatterplot"}: normalized residuals vs. fitted values (diagnostic for missing non-linear effects),
\item \code{"scatterplot2"}: square root of the normalized residuals vs. fitted values (diagnostic for heteroschedasticity),
\item \code{"partial"}: partial residual plot.
}}

\item{type.residual}{[character] the type of residual to be used. Not relevant for \code{type="fit"}.
By default, normalized residuals are used except when requesting a partial residual plot
where this argument specify the variable relative to which the partial residuals are computed (argument \code{variable} in \code{\link{residuals.lmm}}).}

\item{obs.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the original data by cluster.}

\item{obs.size}{[numeric vector of length 2] size of the point and line for the original data.}

\item{facet}{[formula] split the plot into a matrix of panels defined by the variables in the formula.
Internally it calls \code{ggplot2::facet_wrap} or \code{ggplot2::facet_grid} depending on whether the formula contains a variable on the left hand side.}

\item{facet_nrow}{[integer] number of rows of panels in the graphical display.}

\item{facet_ncol}{[integer] number of columns of panels  in the graphical display.}

\item{scales, labeller}{[character] Passed to \code{ggplot2::facet_wrap}.}

\item{at}{[data.frame] values for the covariates at which to evaluate the fitted values or partial residuals.}

\item{time.var}{[character] x-axis variable for the plot.}

\item{color}{[character] name of the variable in the dataset used to color the curve. No color is used when set to \code{FALSE}.}

\item{position}{[character] relative position of the points when colored according to a variable.}

\item{ci}{[logical] should confidence intervals be displayed?}

\item{ci.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the confidence intervals.}

\item{ylim}{[numeric vector of length 2] the lower and higher value of the vertical axis.}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{size.text}{[numeric, >0] size of the font used to display text.}

\item{position.errorbar}{[character] relative position of the errorbars.}

\item{...}{arguments passed to the \code{predict.lmm} or \code{autoplot.residual_lmm} functions.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Display fitted values or residual plot for the mean, variance, and correlation structure.
Can also display quantile-quantile plot relative to the normal distribution.
}
\section{Functions}{
\itemize{
\item \code{plot(lmm)}: Graphical Display For Linear Mixed Models

}}
\examples{
if(require(ggplot2)){

#### simulate data in the long format ####
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")
dL$X1 <- as.factor(dL$X1)

#### fit Linear Mixed Model ####
eCS.lmm <- lmm(Y ~ visit + X1 + X6,
               repetition = ~visit|id, structure = "CS", data = dL, df = FALSE)

#### model fit ####
plot(eCS.lmm, type = "fit", facet =~X1)
## customize display
gg <- autoplot(eCS.lmm, type = "fit", facet =~X1)$plot
gg + coord_cartesian(ylim = c(0,6))
## restrict to specific covariate value
plot(eCS.lmm, type = "fit", at = data.frame(X6=1), color = "X1")

#### qqplot ####
plot(eCS.lmm, type = "qqplot")
plot(eCS.lmm, type = "qqplot", engine.qqplot = "qqtest")

#### residual correlation ####
plot(eCS.lmm, type = "correlation")

#### residual trend ####
plot(eCS.lmm, type = "scatterplot")

#### residual heteroschedasticity ####
plot(eCS.lmm, type = "scatterplot2")

#### partial residuals ####
plot(eCS.lmm, type = "partial", type.residual = "visit") 
plot(eCS.lmm, type = "partial", type.residual = c("(Intercept)","X1","visit"))
plot(eCS.lmm, type = "partial", type.residual = c("(Intercept)","X1","visit"),
facet = ~X1)
}
}
\seealso{
\code{\link{plot.lmm}} for other graphical display (residual plots, partial residual plots).
}
\keyword{hplot}
