% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt.test.R
\name{mt.test}
\alias{mt.test}
\title{Multiple Student's t-Test}
\usage{
mt.test(formula, data, method = NULL, level = 0.95, trace = TRUE)
}
\arguments{
\item{formula}{A formula like \code{Y1+Y2+Y3~X|id} with: \itemize{
\item the outcome on the left hand side (separated with +)
\item the group variable on the right hand side
\item a variable identifying each line in the dataset (optional)
}}

\item{data}{dataset in the wide format. Should inherit from data.frame.}

\item{method}{[character] type of adjustment for multiple comparisons, one of \code{"none"}, \code{"bonferroni"}, ..., \code{"fdr"}, \code{"single-step"}, \code{"single-step2"}.
See \code{\link{confint.Wald_lmm}} for more details.
By default \code{"single-step"} when the test statistics have equal degrees of freedom and otherwise \code{"single-step2"}.}

\item{level}{[numeric,0-1] the confidence level of the confidence intervals.}

\item{trace}{[logical] should a message be displayed in the console when there are missing data.}
}
\value{
A data.frame with the estimates, confidence intervals, and p-values relative to each outcome.
Depending on the argument \code{method} confidence intervals and p-values may be adjusted for multiple comparisons.
The data.frame has an attribute \code{mlmm} containing the underlying regression models.
}
\description{
Perform multiple Student's t-Test via heteroschedastic linear regression
and combine the results, possibly adjusted for multiplicity.
}
\details{
In presence of missing values, performs a outcome specific complete case analysis.
}
\examples{
data(calciumW, package = "LMMstar")

t.test(bmd1 ~ grp, data = calciumW)

mt.test(bmd1+bmd2+bmd3+bmd4+bmd5 ~ grp, data = calciumW)
mt.test(bmd1+bmd2+bmd3+bmd4+bmd5 ~ grp|girl, data = calciumW)
mt.test(bmd1+bmd2+bmd3+bmd4+bmd5 ~ grp|girl, data = calciumW, method = "none")
}
\keyword{models}
