% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib.R
\name{importData}
\alias{importData}
\title{Import an LMP dataset}
\usage{
importData(lmp_dataset_code, filters = list())
}
\arguments{
\item{lmp_dataset_code}{A dataset code name (string). Case insensitive.}

\item{filters}{A list of uniquely named atomic vectors or an empty list
for importing the full dataset (which can be slow).}
}
\value{
A data.table with several columns: \code{value_} and \code{flags_} as well as
the columns for each dimension, \code{geo} i.e. country, \code{time_period}
i.e. year, and others.
}
\description{
The available datasets are:
\tabular{ll}{
\strong{lmp_dataset_code} \tab \strong{Description} \cr
LMP_EXPSUMM \tab LMP expenditure by type of action -- summary tables \cr
LMP_EXPME \tab Detailed expenditure by LMP intervention \cr
LMP_PARTSUMM \tab LMP participants by type of action -- summary tables \cr
LMP_PARTME \tab Detailed data on participants by LMP intervention \cr
LMP_IND_ACTSUP \tab Activation-Support -- LMP participants per 100 persons wanting to work \cr
LMP_IND_ACTRU \tab Activation of registered unemployed \cr
LMP_IND_ACTIME \tab Timely activation -- share of LMP entrants not previously long-term unemployed \cr
LMP_IND_EXP \tab LMP expenditure in convenient units (\% of GDP or purchasing power standard per person wanting to work) \cr
LMP_RJRU \tab Persons registered with Public Employment Services \cr
}
}
\examples{
\donttest{
importData('lmp_expsumm',
           list(geo=c('AT','BE','CZ'), unit='MIO_EUR',
                lmp_type='TOT1_9', exptype=c('XIND','XEMP')))
}
}
