% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ntiles.R
\name{ntiles}
\alias{ntiles}
\title{Create vector based on roughly equally sized groups}
\usage{
ntiles(
  x,
  n = 3,
  format = c("rank", "interval", "mean", "median", "center", "left", "right"),
  digits = 3
)
}
\arguments{
\item{x}{a numeric vector}

\item{n}{(approximate) number of quantiles}

\item{format}{a specification of desired output format. One of
"center", "interval", "left", "right", "mean", or "median.}

\item{digits}{desired number of digits for labeling of factors.}
}
\value{
a vector.  The type of vector will depend on \code{format}.
}
\description{
Create vector based on roughly equally sized groups
}
\details{
This is a functional clone of \code{mosaic::ntiles} in order to avoid the dependency. It should be
removed in the future, when there is no need to avoid such dependency, e.g. when \code{{mosaic}} is
available on WASM.
}
\examples{
CRDS |> head(20) |> mutate(group = ntiles(height, 3, format="center"))
CRDS |> head(20) |> mutate(group = ntiles(height, 3, format="interval"))

}
