% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_lss.R, R/textmodel_lss2.R
\name{textmodel_lss}
\alias{textmodel_lss}
\alias{textmodel_lss.dfm}
\alias{textmodel_lss.fcm}
\alias{textmodel_lss.tokens}
\title{Fit a Latent Semantic Scaling model}
\usage{
textmodel_lss(x, ...)

\method{textmodel_lss}{dfm}(
  x,
  seeds,
  terms = NULL,
  k = 300,
  slice = NULL,
  weight = "count",
  cache = FALSE,
  simil_method = "cosine",
  engine = c("RSpectra", "irlba", "rsvd"),
  auto_weight = FALSE,
  include_data = FALSE,
  group_data = FALSE,
  verbose = FALSE,
  ...
)

\method{textmodel_lss}{fcm}(
  x,
  seeds,
  terms = NULL,
  k = 50,
  max_count = 10,
  weight = "count",
  cache = FALSE,
  simil_method = "cosine",
  engine = "rsparse",
  auto_weight = FALSE,
  verbose = FALSE,
  ...
)

\method{textmodel_lss}{tokens}(
  x,
  seeds,
  terms = NULL,
  k = 200,
  min_count = 5,
  engine = "wordvector",
  tolower = TRUE,
  include_data = FALSE,
  group_data = FALSE,
  spatial = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{a dfm or fcm created by \code{\link[quanteda:dfm]{quanteda::dfm()}}, \code{\link[quanteda:fcm]{quanteda::fcm()}},
\link[quanteda:tokens]{quanteda::tokens} or \link[quanteda:tokens_xptr]{quanteda::tokens_xptr} object.}

\item{...}{additional arguments passed to the underlying engine.}

\item{seeds}{a character vector or named numeric vector that contains seed
words. If seed words contain "*", they are interpreted as glob patterns.
See \link[quanteda:valuetype]{quanteda::valuetype}.}

\item{terms}{a character vector or named numeric vector that specify words
for which polarity scores will be computed; if a numeric vector, words' polarity
scores will be weighted accordingly; if \code{NULL}, all the features in \code{x} except
those less frequent than \code{min_count} will be used.}

\item{k}{the number of singular values requested to the SVD engine. Only used
when \code{x} is a \code{dfm}.}

\item{slice}{a number or indices of the components of word vectors used to
compute similarity; \code{slice < k} to further truncate word vectors; useful
for diagnosys and simulation.}

\item{weight}{weighting scheme passed to \code{\link[quanteda:dfm_weight]{quanteda::dfm_weight()}}. Ignored
when \code{engine = "rsparse"}.}

\item{cache}{if \code{TRUE}, save the result of SVD for next execution with identical
\code{x} and settings. Use the \code{base::options(lss_cache_dir)} to change the
location cache files to be save.}

\item{simil_method}{specifies method to compute similarity between features.
The value is passed to \code{\link[quanteda.textstats:textstat_simil]{quanteda.textstats::textstat_simil()}}, "cosine" is
used otherwise.}

\item{engine}{select the engine to factorize \code{x} to generate word vectors.
If \code{x} is a dfm, \code{\link[RSpectra:svds]{RSpectra::svds()}}, \code{\link[irlba:irlba]{irlba::irlba()}} or \code{\link[rsvd:rsvd]{rsvd::rsvd()}}.
If \code{x} is a fcm, \code{\link[rsparse:GloVe]{rsparse::GloVe()}}.
If \code{x} is a tokens (or tokens_xptr), \code{\link[wordvector:textmodel_word2vec]{wordvector::textmodel_word2vec()}}.}

\item{auto_weight}{automatically determine weights to approximate the
polarity of terms to seed words. Deprecated.}

\item{include_data}{if \code{TRUE}, the fitted model includes the dfm supplied as \code{x}.}

\item{group_data}{if \code{TRUE}, apply \code{dfm_group(x)} before saving the dfm.}

\item{verbose}{show messages if \code{TRUE}.}

\item{max_count}{passed to \code{x_max} in \code{rsparse::GloVe$new()} where cooccurrence
counts are ceiled to this threshold. It should be changed according to the
size of the corpus. Used only when \code{x} is a \code{fcm}.}

\item{min_count}{the minimum frequency of the words. Words less frequent than
this in \code{x} are removed before training.}

\item{tolower}{if \code{TRUE}, lower-case all the words in the model.}

\item{spatial}{[experimental] if \code{FALSE}, return a probabilistic model. See the details.}
}
\description{
Latent Semantic Scaling (LSS) is a semi-supervised algorithm for document scaling based on
word embedding.
}
\details{
Latent Semantic Scaling (LSS) is a semisupervised document scaling
method. \code{textmodel_lss()} constructs word vectors from use-provided
documents (\code{x}) and weights words (\code{terms}) based on their semantic
proximity to seed words (\code{seeds}). Seed words are any known polarity words
(e.g. sentiment words) that users should manually choose. The required
number of seed words are usually 5 to 10 for each end of the scale.

If \code{seeds} is a named numeric vector with positive and negative values, a
bipolar model is construct; if \code{seeds} is a character vector, a
unipolar model. Usually bipolar models perform better in document
scaling because both ends of the scale are defined by the user.

A seed word's polarity score computed by \code{textmodel_lss()} tends to diverge
from its original score given by the user because it's score is affected
not only by its original score but also by the original scores of all other
seed words. If \code{auto_weight = TRUE}, the original scores are weighted
automatically using \code{\link[stats:optim]{stats::optim()}} to minimize the squared difference
between seed words' computed and original scores. Weighted scores are saved
in \code{seed_weighted} in the object.

When \code{x} is a tokens or tokens_xptr object, \link[wordvector:textmodel_word2vec]{wordvector::textmodel_word2vec}
is called internally with \code{type = "skip-gram"} and other arguments passed via \code{...}.
If \code{spatial = TRUE}, it return a spatial model; otherwise a probabilistic model.
While the polarity scores of words are their cosine similarity to seed words in
spatial models, they are predicted probability that the seed words to occur in
their contexts. The probabilistic models are still experimental, so use them with caution.

Please visit the \href{https://koheiw.github.io/LSX/}{package website} for examples.
}
\references{
Watanabe, Kohei. 2020. "Latent Semantic Scaling: A Semisupervised
Text Analysis Technique for New Domains and Languages", Communication
Methods and Measures. \doi{10.1080/19312458.2020.1832976}.

Watanabe, Kohei. 2017. "Measuring News Bias: Russia's Official News Agency
ITAR-TASS' Coverage of the Ukraine Crisis" European Journal of
Communication. \doi{10.1177/0267323117695735}.
}
