% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEP_t.R
\name{CEP_t}
\alias{CEP_t}
\title{Compute classification error probabilities for attributes at different time points}
\usage{
CEP_t(fit.object, t, K, N)
}
\arguments{
\item{fit.object}{a list of the G-DINA model objects return from \code{GDINA} R package at pre-and post-tests.}

\item{t}{the number of time points. This package can only handle two time points can for the time being.}

\item{K}{the number of attributes.}

\item{N}{the number of examinees (observations).}
}
\value{
a list with elements
\describe{
\item{cep.matrix}{the CEP matrix}
\item{w}{the correction weights}
\item{mp}{the estimated marginal posterior probabilities obtained from \code{GDINA} R package}
\item{eap}{the estimated EAP of attribute profiles obtained from \code{GDINA} R package}
}
}
\description{
Function to compute classification error probabilities (CEP) for attributes at different time points. Only attribute-level CEP is available for the time being.
}
\examples{
if(requireNamespace("GDINA")){
library(GDINA)
# Assuming dat0, dat1, Q, and other necessary data and objects are predefined.
rdmodel <- c("GDINA","GDINA","GDINA","GDINA","GDINA","GDINA","GDINA","GDINA",
"GDINA","GDINA","GDINA","GDINA","GDINA","GDINA","GDINA","GDINA",
"GDINA","GDINA","GDINA","GDINA","RRUM","GDINA","GDINA","GDINA",
"GDINA","LLM","LLM","RRUM","ACDM","GDINA","GDINA","GDINA",
"GDINA","GDINA","GDINA","GDINA","GDINA","GDINA","GDINA","GDINA")
fitrd <- GDINA(dat = dat0, Q = Q, model= rdmodel, mono.constraint = TRUE, verbose=0)

# Obtained the item parameters from Tan et al. (2022)
itemparm.rd = GDINA::extract(fitrd,"catprob.parm")

# Fit the response data at pre-test to the selected models
fit.t1 = GDINA(dat = dat1[,3:42], Q = Q, mono.constraint = TRUE, model = rdmodel,
catprob.parm = itemparm.rd, att.dist = "independent", control=list(maxitr = 0), verbose=0)

# Fit the response data at post-test to the selected models
fit.t2 = GDINA(dat = dat1[,43:82], Q = Q, mono.constraint = TRUE, model = rdmodel,
catprob.parm = itemparm.rd, att.dist = "independent", control=list(maxitr = 0), verbose=0)
fit.object = list()
fit.object[[1]] <- fit.t1
fit.object[[2]] <- fit.t2
t = 2 # the number of time points
K = ncol(Q) # the number of attributes
N = nrow(dat1) # the number of observations

cep = CEP_t(fit.object = fit.object, t = t, K = K, N = N)

# The CEP matrices of the attributes
cep$cep.matrix

}
}
\references{
\itemize{
\item{Liang, Q., de la Torre, J., & Law, N. (2023).Latent transition cognitive diagnosis model with covariates: A three-step approach. \emph{Journal of Educational and Behavioral Statistics}. \doi{10.3102/10769986231163320}}
\item{Huebner, A., & Wang, C. (2011).A note on comparing examinee classification methods for cognitive diagnosis models. \emph{Educational and Psychological Measurement, 71}, 407-419. \doi{10.1177/0013164410388832}}
}
}
