% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.class.R
\name{update_class}
\alias{update_class}
\title{Classification update using the Bayes' Theorem}
\usage{
update_class(cep, K, t, z_t1, z_t2, beta, gamma_01, gamma_10)
}
\arguments{
\item{cep}{estimated classification error probabilities returned from \code{\link{CEP_t}}. The uncorrected attribute profile (EAP) is also stored in this object.}

\item{K}{the number of attributes.}

\item{t}{the number of time points. This package can only handle two time points can for the time being.}

\item{z_t1}{covariates at Time 1, which has already had the intercept column (1s).}

\item{z_t2}{covariates at Time 2, which has already had the intercept column (1s).}

\item{beta}{the estimated regression coefficients at Time 1 (initial state)}

\item{gamma_01}{the estimated regression coefficients of transition from absence (0) to presence (1) at Time 2}

\item{gamma_10}{the estimated regression coefficients of transition from absence (0) to presence (1) at Time 2}
}
\value{
a list with elements
\describe{
\item{post.prob}{the corrected and updated posterior probability}
\item{att.prevalance}{the corrected and updated attribute prevalance}
\item{cor.profile}{the corrected and updated attribute profiles for different time points}
}
}
\description{
Function to update classifications (attribute profiles) using the Bayes' Theorem
}
\examples{
\dontrun{
#The run is dependent on the output of the step3.est() function and CEP_t() function
#It is not recommended for run it.
t = 2 # the number of time points
K = ncol(Q) # the number of attributes
Z = dat1[, c(1,2)]
z_t1 = cbind(1, Z$gender)  # Covariate at time 1
z_t2 = cbind(1, Z$gender, Z$intervention, apply(Z,1,prod)) # Covariates at time 2
beta = step3.output$beta
gamma_01 = step3.output$gamma_01
gamma_10 = step3.output$gamma_10

# Update classifications using the Bayes' Theorem
updated.class <- update.class(cep = cep, K = K, t = t, z_t1 = z_t1, z_t2 = z_t2,
                              beta = beta, gamma_01 = gamma_01, gamma_10 = gamma_10)

# The corrected and updated attribute prevalance
updated.class$att.prevalance

# The corrected and updated posterior probability
updated.class$post.prob
}

}
\references{
Liang, Q., de la Torre, J., & Law, N. (2023). Latent transition cognitive diagnosis model with covariates: A three-step approach. \emph{Journal of Educational and Behavioral Statistics}.\doi{10.3102/10769986231163320}
}
